/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.WatchEvent;
import io.dekorate.deps.kubernetes.api.model.WatchEventFluent;
import io.dekorate.deps.kubernetes.api.model.WatchEventFluentImpl;

public class WatchEventBuilder
extends WatchEventFluentImpl<WatchEventBuilder>
implements VisitableBuilder<WatchEvent, WatchEventBuilder> {
    WatchEventFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public WatchEventBuilder() {
        this(true);
    }

    public WatchEventBuilder(Boolean validationEnabled) {
        this(new WatchEvent(), validationEnabled);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new WatchEvent(), validationEnabled);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent, WatchEvent instance) {
        this(fluent, instance, true);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent, WatchEvent instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withObject(instance.getObject());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public WatchEventBuilder(WatchEvent instance) {
        this(instance, (Boolean)true);
    }

    public WatchEventBuilder(WatchEvent instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withObject(instance.getObject());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public WatchEventBuilder(Validator validator) {
        this(new WatchEvent(), (Boolean)true);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent, WatchEvent instance, Validator validator) {
        this.fluent = fluent;
        fluent.withObject(instance.getObject());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public WatchEventBuilder(WatchEvent instance, Validator validator) {
        this.fluent = this;
        this.withObject(instance.getObject());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public WatchEvent build() {
        WatchEvent buildable = new WatchEvent(this.fluent.getObject(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WatchEventBuilder that = (WatchEventBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

