/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.admission;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.admission.AdmissionRequest;
import io.dekorate.deps.kubernetes.api.model.admission.AdmissionRequestFluent;
import io.dekorate.deps.kubernetes.api.model.admission.AdmissionRequestFluentImpl;

public class AdmissionRequestBuilder
extends AdmissionRequestFluentImpl<AdmissionRequestBuilder>
implements VisitableBuilder<AdmissionRequest, AdmissionRequestBuilder> {
    AdmissionRequestFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AdmissionRequestBuilder() {
        this(true);
    }

    public AdmissionRequestBuilder(Boolean validationEnabled) {
        this(new AdmissionRequest(), validationEnabled);
    }

    public AdmissionRequestBuilder(AdmissionRequestFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AdmissionRequestBuilder(AdmissionRequestFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AdmissionRequest(), validationEnabled);
    }

    public AdmissionRequestBuilder(AdmissionRequestFluent<?> fluent, AdmissionRequest instance) {
        this(fluent, instance, true);
    }

    public AdmissionRequestBuilder(AdmissionRequestFluent<?> fluent, AdmissionRequest instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDryRun(instance.getDryRun());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withObject(instance.getObject());
        fluent.withOldObject(instance.getOldObject());
        fluent.withOperation(instance.getOperation());
        fluent.withResource(instance.getResource());
        fluent.withSubResource(instance.getSubResource());
        fluent.withUid(instance.getUid());
        fluent.withUserInfo(instance.getUserInfo());
        this.validationEnabled = validationEnabled;
    }

    public AdmissionRequestBuilder(AdmissionRequest instance) {
        this(instance, (Boolean)true);
    }

    public AdmissionRequestBuilder(AdmissionRequest instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDryRun(instance.getDryRun());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withObject(instance.getObject());
        this.withOldObject(instance.getOldObject());
        this.withOperation(instance.getOperation());
        this.withResource(instance.getResource());
        this.withSubResource(instance.getSubResource());
        this.withUid(instance.getUid());
        this.withUserInfo(instance.getUserInfo());
        this.validationEnabled = validationEnabled;
    }

    public AdmissionRequestBuilder(Validator validator) {
        this(new AdmissionRequest(), (Boolean)true);
    }

    public AdmissionRequestBuilder(AdmissionRequestFluent<?> fluent, AdmissionRequest instance, Validator validator) {
        this.fluent = fluent;
        fluent.withDryRun(instance.getDryRun());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withObject(instance.getObject());
        fluent.withOldObject(instance.getOldObject());
        fluent.withOperation(instance.getOperation());
        fluent.withResource(instance.getResource());
        fluent.withSubResource(instance.getSubResource());
        fluent.withUid(instance.getUid());
        fluent.withUserInfo(instance.getUserInfo());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public AdmissionRequestBuilder(AdmissionRequest instance, Validator validator) {
        this.fluent = this;
        this.withDryRun(instance.getDryRun());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withObject(instance.getObject());
        this.withOldObject(instance.getOldObject());
        this.withOperation(instance.getOperation());
        this.withResource(instance.getResource());
        this.withSubResource(instance.getSubResource());
        this.withUid(instance.getUid());
        this.withUserInfo(instance.getUserInfo());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public AdmissionRequest build() {
        AdmissionRequest buildable = new AdmissionRequest(this.fluent.isDryRun(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getObject(), this.fluent.getOldObject(), this.fluent.getOperation(), this.fluent.getResource(), this.fluent.getSubResource(), this.fluent.getUid(), this.fluent.getUserInfo());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdmissionRequestBuilder that = (AdmissionRequestBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

