/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.admission;

import io.dekorate.deps.jackson.annotation.JsonAnyGetter;
import io.dekorate.deps.jackson.annotation.JsonAnySetter;
import io.dekorate.deps.jackson.annotation.JsonIgnore;
import io.dekorate.deps.jackson.annotation.JsonInclude;
import io.dekorate.deps.jackson.annotation.JsonProperty;
import io.dekorate.deps.jackson.annotation.JsonPropertyOrder;
import io.dekorate.deps.jackson.databind.JsonDeserializer;
import io.dekorate.deps.jackson.databind.annotation.JsonDeserialize;
import io.dekorate.deps.javax.validation.Valid;
import io.dekorate.deps.javax.validation.constraints.NotNull;
import io.dekorate.deps.kubernetes.api.model.KubernetesResource;
import io.dekorate.deps.kubernetes.api.model.admission.AdmissionRequest;
import io.dekorate.deps.kubernetes.api.model.admission.AdmissionResponse;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "request", "response"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class AdmissionReview
implements KubernetesResource {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "admission.k8s.io/v1beta1";
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "AdmissionReview";
    @JsonProperty(value="request")
    @Valid
    private AdmissionRequest request;
    @JsonProperty(value="response")
    @Valid
    private AdmissionResponse response;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public AdmissionReview() {
    }

    public AdmissionReview(String apiVersion, String kind, AdmissionRequest request, AdmissionResponse response) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.request = request;
        this.response = response;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="request")
    public AdmissionRequest getRequest() {
        return this.request;
    }

    @JsonProperty(value="request")
    public void setRequest(AdmissionRequest request) {
        this.request = request;
    }

    @JsonProperty(value="response")
    public AdmissionResponse getResponse() {
        return this.response;
    }

    @JsonProperty(value="response")
    public void setResponse(AdmissionResponse response) {
        this.response = response;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "AdmissionReview(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdmissionReview)) {
            return false;
        }
        AdmissionReview other = (AdmissionReview)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        AdmissionRequest this$request = this.getRequest();
        AdmissionRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        AdmissionResponse this$response = this.getResponse();
        AdmissionResponse other$response = other.getResponse();
        if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdmissionReview;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        AdmissionRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        AdmissionResponse $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

