/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.admissionregistration;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.admissionregistration.ValidatingWebhookConfiguration;
import io.dekorate.deps.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationFluent;
import io.dekorate.deps.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationFluentImpl;

public class ValidatingWebhookConfigurationBuilder
extends ValidatingWebhookConfigurationFluentImpl<ValidatingWebhookConfigurationBuilder>
implements VisitableBuilder<ValidatingWebhookConfiguration, ValidatingWebhookConfigurationBuilder> {
    ValidatingWebhookConfigurationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ValidatingWebhookConfigurationBuilder() {
        this(true);
    }

    public ValidatingWebhookConfigurationBuilder(Boolean validationEnabled) {
        this(new ValidatingWebhookConfiguration(), validationEnabled);
    }

    public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ValidatingWebhookConfiguration(), validationEnabled);
    }

    public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent, ValidatingWebhookConfiguration instance) {
        this(fluent, instance, true);
    }

    public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent, ValidatingWebhookConfiguration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withWebhooks(instance.getWebhooks());
        this.validationEnabled = validationEnabled;
    }

    public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfiguration instance) {
        this(instance, (Boolean)true);
    }

    public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfiguration instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withWebhooks(instance.getWebhooks());
        this.validationEnabled = validationEnabled;
    }

    public ValidatingWebhookConfigurationBuilder(Validator validator) {
        this(new ValidatingWebhookConfiguration(), (Boolean)true);
    }

    public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent, ValidatingWebhookConfiguration instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withWebhooks(instance.getWebhooks());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfiguration instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withWebhooks(instance.getWebhooks());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ValidatingWebhookConfiguration build() {
        ValidatingWebhookConfiguration buildable = new ValidatingWebhookConfiguration(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getWebhooks());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValidatingWebhookConfigurationBuilder that = (ValidatingWebhookConfigurationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

