/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.apps;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.apps.StatefulSetList;
import io.dekorate.deps.kubernetes.api.model.apps.StatefulSetListFluent;
import io.dekorate.deps.kubernetes.api.model.apps.StatefulSetListFluentImpl;

public class StatefulSetListBuilder
extends StatefulSetListFluentImpl<StatefulSetListBuilder>
implements VisitableBuilder<StatefulSetList, StatefulSetListBuilder> {
    StatefulSetListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StatefulSetListBuilder() {
        this(true);
    }

    public StatefulSetListBuilder(Boolean validationEnabled) {
        this(new StatefulSetList(), validationEnabled);
    }

    public StatefulSetListBuilder(StatefulSetListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatefulSetListBuilder(StatefulSetListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetList(), validationEnabled);
    }

    public StatefulSetListBuilder(StatefulSetListFluent<?> fluent, StatefulSetList instance) {
        this(fluent, instance, true);
    }

    public StatefulSetListBuilder(StatefulSetListFluent<?> fluent, StatefulSetList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetListBuilder(StatefulSetList instance) {
        this(instance, (Boolean)true);
    }

    public StatefulSetListBuilder(StatefulSetList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetListBuilder(Validator validator) {
        this(new StatefulSetList(), (Boolean)true);
    }

    public StatefulSetListBuilder(StatefulSetListFluent<?> fluent, StatefulSetList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public StatefulSetListBuilder(StatefulSetList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public StatefulSetList build() {
        StatefulSetList buildable = new StatefulSetList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetListBuilder that = (StatefulSetListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

