/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.authentication;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.authentication.TokenReviewSpec;
import io.dekorate.deps.kubernetes.api.model.authentication.TokenReviewSpecFluent;
import io.dekorate.deps.kubernetes.api.model.authentication.TokenReviewSpecFluentImpl;

public class TokenReviewSpecBuilder
extends TokenReviewSpecFluentImpl<TokenReviewSpecBuilder>
implements VisitableBuilder<TokenReviewSpec, TokenReviewSpecBuilder> {
    TokenReviewSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TokenReviewSpecBuilder() {
        this(true);
    }

    public TokenReviewSpecBuilder(Boolean validationEnabled) {
        this(new TokenReviewSpec(), validationEnabled);
    }

    public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenReviewSpec(), validationEnabled);
    }

    public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent, TokenReviewSpec instance) {
        this(fluent, instance, true);
    }

    public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent, TokenReviewSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAudiences(instance.getAudiences());
        fluent.withToken(instance.getToken());
        this.validationEnabled = validationEnabled;
    }

    public TokenReviewSpecBuilder(TokenReviewSpec instance) {
        this(instance, (Boolean)true);
    }

    public TokenReviewSpecBuilder(TokenReviewSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAudiences(instance.getAudiences());
        this.withToken(instance.getToken());
        this.validationEnabled = validationEnabled;
    }

    public TokenReviewSpecBuilder(Validator validator) {
        this(new TokenReviewSpec(), (Boolean)true);
    }

    public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent, TokenReviewSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAudiences(instance.getAudiences());
        fluent.withToken(instance.getToken());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TokenReviewSpecBuilder(TokenReviewSpec instance, Validator validator) {
        this.fluent = this;
        this.withAudiences(instance.getAudiences());
        this.withToken(instance.getToken());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public TokenReviewSpec build() {
        TokenReviewSpec buildable = new TokenReviewSpec(this.fluent.getAudiences(), this.fluent.getToken());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenReviewSpecBuilder that = (TokenReviewSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

