/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.batch;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.batch.JobCondition;
import io.dekorate.deps.kubernetes.api.model.batch.JobConditionFluent;
import io.dekorate.deps.kubernetes.api.model.batch.JobConditionFluentImpl;

public class JobConditionBuilder
extends JobConditionFluentImpl<JobConditionBuilder>
implements VisitableBuilder<JobCondition, JobConditionBuilder> {
    JobConditionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public JobConditionBuilder() {
        this(true);
    }

    public JobConditionBuilder(Boolean validationEnabled) {
        this(new JobCondition(), validationEnabled);
    }

    public JobConditionBuilder(JobConditionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JobConditionBuilder(JobConditionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JobCondition(), validationEnabled);
    }

    public JobConditionBuilder(JobConditionFluent<?> fluent, JobCondition instance) {
        this(fluent, instance, true);
    }

    public JobConditionBuilder(JobConditionFluent<?> fluent, JobCondition instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLastProbeTime(instance.getLastProbeTime());
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public JobConditionBuilder(JobCondition instance) {
        this(instance, (Boolean)true);
    }

    public JobConditionBuilder(JobCondition instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLastProbeTime(instance.getLastProbeTime());
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public JobConditionBuilder(Validator validator) {
        this(new JobCondition(), (Boolean)true);
    }

    public JobConditionBuilder(JobConditionFluent<?> fluent, JobCondition instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLastProbeTime(instance.getLastProbeTime());
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public JobConditionBuilder(JobCondition instance, Validator validator) {
        this.fluent = this;
        this.withLastProbeTime(instance.getLastProbeTime());
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public JobCondition build() {
        JobCondition buildable = new JobCondition(this.fluent.getLastProbeTime(), this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobConditionBuilder that = (JobConditionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

