/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.batch;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.batch.JobTemplateSpec;
import io.dekorate.deps.kubernetes.api.model.batch.JobTemplateSpecFluent;
import io.dekorate.deps.kubernetes.api.model.batch.JobTemplateSpecFluentImpl;

public class JobTemplateSpecBuilder
extends JobTemplateSpecFluentImpl<JobTemplateSpecBuilder>
implements VisitableBuilder<JobTemplateSpec, JobTemplateSpecBuilder> {
    JobTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public JobTemplateSpecBuilder() {
        this(true);
    }

    public JobTemplateSpecBuilder(Boolean validationEnabled) {
        this(new JobTemplateSpec(), validationEnabled);
    }

    public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JobTemplateSpec(), validationEnabled);
    }

    public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent, JobTemplateSpec instance) {
        this(fluent, instance, true);
    }

    public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent, JobTemplateSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public JobTemplateSpecBuilder(JobTemplateSpec instance) {
        this(instance, (Boolean)true);
    }

    public JobTemplateSpecBuilder(JobTemplateSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public JobTemplateSpecBuilder(Validator validator) {
        this(new JobTemplateSpec(), (Boolean)true);
    }

    public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent, JobTemplateSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public JobTemplateSpecBuilder(JobTemplateSpec instance, Validator validator) {
        this.fluent = this;
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public JobTemplateSpec build() {
        JobTemplateSpec buildable = new JobTemplateSpec(this.fluent.getMetadata(), this.fluent.getSpec());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobTemplateSpecBuilder that = (JobTemplateSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

