/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.certificates;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.certificates.CertificateSigningRequestSpec;
import io.dekorate.deps.kubernetes.api.model.certificates.CertificateSigningRequestSpecFluent;
import io.dekorate.deps.kubernetes.api.model.certificates.CertificateSigningRequestSpecFluentImpl;

public class CertificateSigningRequestSpecBuilder
extends CertificateSigningRequestSpecFluentImpl<CertificateSigningRequestSpecBuilder>
implements VisitableBuilder<CertificateSigningRequestSpec, CertificateSigningRequestSpecBuilder> {
    CertificateSigningRequestSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CertificateSigningRequestSpecBuilder() {
        this(true);
    }

    public CertificateSigningRequestSpecBuilder(Boolean validationEnabled) {
        this(new CertificateSigningRequestSpec(), validationEnabled);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CertificateSigningRequestSpec(), validationEnabled);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent, CertificateSigningRequestSpec instance) {
        this(fluent, instance, true);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent, CertificateSigningRequestSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExtra(instance.getExtra());
        fluent.withGroups(instance.getGroups());
        fluent.withRequest(instance.getRequest());
        fluent.withUid(instance.getUid());
        fluent.withUsages(instance.getUsages());
        fluent.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpec instance) {
        this(instance, (Boolean)true);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withRequest(instance.getRequest());
        this.withUid(instance.getUid());
        this.withUsages(instance.getUsages());
        this.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    public CertificateSigningRequestSpecBuilder(Validator validator) {
        this(new CertificateSigningRequestSpec(), (Boolean)true);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent, CertificateSigningRequestSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withExtra(instance.getExtra());
        fluent.withGroups(instance.getGroups());
        fluent.withRequest(instance.getRequest());
        fluent.withUid(instance.getUid());
        fluent.withUsages(instance.getUsages());
        fluent.withUsername(instance.getUsername());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpec instance, Validator validator) {
        this.fluent = this;
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withRequest(instance.getRequest());
        this.withUid(instance.getUid());
        this.withUsages(instance.getUsages());
        this.withUsername(instance.getUsername());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public CertificateSigningRequestSpec build() {
        CertificateSigningRequestSpec buildable = new CertificateSigningRequestSpec(this.fluent.getExtra(), this.fluent.getGroups(), this.fluent.getRequest(), this.fluent.getUid(), this.fluent.getUsages(), this.fluent.getUsername());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateSigningRequestSpecBuilder that = (CertificateSigningRequestSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

