/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.certificates;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.certificates.CertificateSigningRequestStatus;
import io.dekorate.deps.kubernetes.api.model.certificates.CertificateSigningRequestStatusFluent;
import io.dekorate.deps.kubernetes.api.model.certificates.CertificateSigningRequestStatusFluentImpl;

public class CertificateSigningRequestStatusBuilder
extends CertificateSigningRequestStatusFluentImpl<CertificateSigningRequestStatusBuilder>
implements VisitableBuilder<CertificateSigningRequestStatus, CertificateSigningRequestStatusBuilder> {
    CertificateSigningRequestStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CertificateSigningRequestStatusBuilder() {
        this(true);
    }

    public CertificateSigningRequestStatusBuilder(Boolean validationEnabled) {
        this(new CertificateSigningRequestStatus(), validationEnabled);
    }

    public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CertificateSigningRequestStatus(), validationEnabled);
    }

    public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent, CertificateSigningRequestStatus instance) {
        this(fluent, instance, true);
    }

    public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent, CertificateSigningRequestStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCertificate(instance.getCertificate());
        fluent.withConditions(instance.getConditions());
        this.validationEnabled = validationEnabled;
    }

    public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatus instance) {
        this(instance, (Boolean)true);
    }

    public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCertificate(instance.getCertificate());
        this.withConditions(instance.getConditions());
        this.validationEnabled = validationEnabled;
    }

    public CertificateSigningRequestStatusBuilder(Validator validator) {
        this(new CertificateSigningRequestStatus(), (Boolean)true);
    }

    public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent, CertificateSigningRequestStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCertificate(instance.getCertificate());
        fluent.withConditions(instance.getConditions());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatus instance, Validator validator) {
        this.fluent = this;
        this.withCertificate(instance.getCertificate());
        this.withConditions(instance.getConditions());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public CertificateSigningRequestStatus build() {
        CertificateSigningRequestStatus buildable = new CertificateSigningRequestStatus(this.fluent.getCertificate(), this.fluent.getConditions());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateSigningRequestStatusBuilder that = (CertificateSigningRequestStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

