/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.extensions;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressBackend;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressBackendFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressBackendFluentImpl;

public class IngressBackendBuilder
extends IngressBackendFluentImpl<IngressBackendBuilder>
implements VisitableBuilder<IngressBackend, IngressBackendBuilder> {
    IngressBackendFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IngressBackendBuilder() {
        this(true);
    }

    public IngressBackendBuilder(Boolean validationEnabled) {
        this(new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance) {
        this(fluent, instance, true);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withServiceName(instance.getServiceName());
        fluent.withServicePort(instance.getServicePort());
        this.validationEnabled = validationEnabled;
    }

    public IngressBackendBuilder(IngressBackend instance) {
        this(instance, (Boolean)true);
    }

    public IngressBackendBuilder(IngressBackend instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
        this.validationEnabled = validationEnabled;
    }

    public IngressBackendBuilder(Validator validator) {
        this(new IngressBackend(), (Boolean)true);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance, Validator validator) {
        this.fluent = fluent;
        fluent.withServiceName(instance.getServiceName());
        fluent.withServicePort(instance.getServicePort());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IngressBackendBuilder(IngressBackend instance, Validator validator) {
        this.fluent = this;
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public IngressBackend build() {
        IngressBackend buildable = new IngressBackend(this.fluent.getServiceName(), this.fluent.getServicePort());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendBuilder that = (IngressBackendBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

