/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.extensions;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressRule;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressRuleFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressRuleFluentImpl;

public class IngressRuleBuilder
extends IngressRuleFluentImpl<IngressRuleBuilder>
implements VisitableBuilder<IngressRule, IngressRuleBuilder> {
    IngressRuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IngressRuleBuilder() {
        this(true);
    }

    public IngressRuleBuilder(Boolean validationEnabled) {
        this(new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance) {
        this(fluent, instance, true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttp(instance.getHttp());
        this.validationEnabled = validationEnabled;
    }

    public IngressRuleBuilder(IngressRule instance) {
        this(instance, (Boolean)true);
    }

    public IngressRuleBuilder(IngressRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
        this.validationEnabled = validationEnabled;
    }

    public IngressRuleBuilder(Validator validator) {
        this(new IngressRule(), (Boolean)true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance, Validator validator) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttp(instance.getHttp());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IngressRuleBuilder(IngressRule instance, Validator validator) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public IngressRule build() {
        IngressRule buildable = new IngressRule(this.fluent.getHost(), this.fluent.getHttp());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleBuilder that = (IngressRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

