/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.extensions;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressStatus;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressStatusFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressStatusFluentImpl;

public class IngressStatusBuilder
extends IngressStatusFluentImpl<IngressStatusBuilder>
implements VisitableBuilder<IngressStatus, IngressStatusBuilder> {
    IngressStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IngressStatusBuilder() {
        this(true);
    }

    public IngressStatusBuilder(Boolean validationEnabled) {
        this(new IngressStatus(), validationEnabled);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressStatus(), validationEnabled);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent, IngressStatus instance) {
        this(fluent, instance, true);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent, IngressStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLoadBalancer(instance.getLoadBalancer());
        this.validationEnabled = validationEnabled;
    }

    public IngressStatusBuilder(IngressStatus instance) {
        this(instance, (Boolean)true);
    }

    public IngressStatusBuilder(IngressStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLoadBalancer(instance.getLoadBalancer());
        this.validationEnabled = validationEnabled;
    }

    public IngressStatusBuilder(Validator validator) {
        this(new IngressStatus(), (Boolean)true);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent, IngressStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLoadBalancer(instance.getLoadBalancer());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IngressStatusBuilder(IngressStatus instance, Validator validator) {
        this.fluent = this;
        this.withLoadBalancer(instance.getLoadBalancer());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public IngressStatus build() {
        IngressStatus buildable = new IngressStatus(this.fluent.getLoadBalancer());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressStatusBuilder that = (IngressStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

