/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.extensions;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.extensions.PodSecurityPolicy;
import io.dekorate.deps.kubernetes.api.model.extensions.PodSecurityPolicyFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.PodSecurityPolicyFluentImpl;

public class PodSecurityPolicyBuilder
extends PodSecurityPolicyFluentImpl<PodSecurityPolicyBuilder>
implements VisitableBuilder<PodSecurityPolicy, PodSecurityPolicyBuilder> {
    PodSecurityPolicyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodSecurityPolicyBuilder() {
        this(true);
    }

    public PodSecurityPolicyBuilder(Boolean validationEnabled) {
        this(new PodSecurityPolicy(), validationEnabled);
    }

    public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodSecurityPolicy(), validationEnabled);
    }

    public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent, PodSecurityPolicy instance) {
        this(fluent, instance, true);
    }

    public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent, PodSecurityPolicy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityPolicyBuilder(PodSecurityPolicy instance) {
        this(instance, (Boolean)true);
    }

    public PodSecurityPolicyBuilder(PodSecurityPolicy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityPolicyBuilder(Validator validator) {
        this(new PodSecurityPolicy(), (Boolean)true);
    }

    public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent, PodSecurityPolicy instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodSecurityPolicyBuilder(PodSecurityPolicy instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PodSecurityPolicy build() {
        PodSecurityPolicy buildable = new PodSecurityPolicy(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicyBuilder that = (PodSecurityPolicyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

