/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.networking;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.networking.NetworkPolicySpec;
import io.dekorate.deps.kubernetes.api.model.networking.NetworkPolicySpecFluent;
import io.dekorate.deps.kubernetes.api.model.networking.NetworkPolicySpecFluentImpl;

public class NetworkPolicySpecBuilder
extends NetworkPolicySpecFluentImpl<NetworkPolicySpecBuilder>
implements VisitableBuilder<NetworkPolicySpec, NetworkPolicySpecBuilder> {
    NetworkPolicySpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NetworkPolicySpecBuilder() {
        this(true);
    }

    public NetworkPolicySpecBuilder(Boolean validationEnabled) {
        this(new NetworkPolicySpec(), validationEnabled);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicySpec(), validationEnabled);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, NetworkPolicySpec instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, NetworkPolicySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEgress(instance.getEgress());
        fluent.withIngress(instance.getIngress());
        fluent.withPodSelector(instance.getPodSelector());
        fluent.withPolicyTypes(instance.getPolicyTypes());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpec instance) {
        this(instance, (Boolean)true);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicySpecBuilder(Validator validator) {
        this(new NetworkPolicySpec(), (Boolean)true);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, NetworkPolicySpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withEgress(instance.getEgress());
        fluent.withIngress(instance.getIngress());
        fluent.withPodSelector(instance.getPodSelector());
        fluent.withPolicyTypes(instance.getPolicyTypes());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpec instance, Validator validator) {
        this.fluent = this;
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NetworkPolicySpec build() {
        NetworkPolicySpec buildable = new NetworkPolicySpec(this.fluent.getEgress(), this.fluent.getIngress(), this.fluent.getPodSelector(), this.fluent.getPolicyTypes());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicySpecBuilder that = (NetworkPolicySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

