/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.rbac;

import io.dekorate.deps.jackson.annotation.JsonAnyGetter;
import io.dekorate.deps.jackson.annotation.JsonAnySetter;
import io.dekorate.deps.jackson.annotation.JsonIgnore;
import io.dekorate.deps.jackson.annotation.JsonInclude;
import io.dekorate.deps.jackson.annotation.JsonProperty;
import io.dekorate.deps.jackson.annotation.JsonPropertyOrder;
import io.dekorate.deps.jackson.databind.JsonDeserializer;
import io.dekorate.deps.jackson.databind.annotation.JsonDeserialize;
import io.dekorate.deps.javax.validation.Valid;
import io.dekorate.deps.javax.validation.constraints.NotNull;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleRef;
import io.dekorate.deps.kubernetes.api.model.rbac.Subject;
import io.dekorate.deps.kubernetes.api.model.validators.CheckObjectMeta;
import io.dekorate.deps.kubernetes.model.annotation.ApiGroup;
import io.dekorate.deps.kubernetes.model.annotation.ApiVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "roleRef", "subjects"})
@JsonDeserialize(using=JsonDeserializer.None.class)
@ApiVersion(value="v1")
@ApiGroup(value="rbac.authorization.k8s.io")
public class RoleBinding
implements HasMetadata {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "rbac.authorization.k8s.io/v1";
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "RoleBinding";
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(minimal=true)
    private ObjectMeta metadata;
    @JsonProperty(value="roleRef")
    @Valid
    private RoleRef roleRef;
    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<Subject> subjects = new ArrayList<Subject>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public RoleBinding() {
    }

    public RoleBinding(String apiVersion, String kind, ObjectMeta metadata, RoleRef roleRef, List<Subject> subjects) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.metadata = metadata;
        this.roleRef = roleRef;
        this.subjects = subjects;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="roleRef")
    public RoleRef getRoleRef() {
        return this.roleRef;
    }

    @JsonProperty(value="roleRef")
    public void setRoleRef(RoleRef roleRef) {
        this.roleRef = roleRef;
    }

    @JsonProperty(value="subjects")
    public List<Subject> getSubjects() {
        return this.subjects;
    }

    @JsonProperty(value="subjects")
    public void setSubjects(List<Subject> subjects) {
        this.subjects = subjects;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "RoleBinding(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", roleRef=" + this.getRoleRef() + ", subjects=" + this.getSubjects() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleBinding)) {
            return false;
        }
        RoleBinding other = (RoleBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        RoleRef this$roleRef = this.getRoleRef();
        RoleRef other$roleRef = other.getRoleRef();
        if (this$roleRef == null ? other$roleRef != null : !((Object)this$roleRef).equals(other$roleRef)) {
            return false;
        }
        List<Subject> this$subjects = this.getSubjects();
        List<Subject> other$subjects = other.getSubjects();
        if (this$subjects == null ? other$subjects != null : !((Object)this$subjects).equals(other$subjects)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoleBinding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        RoleRef $roleRef = this.getRoleRef();
        result = result * 59 + ($roleRef == null ? 43 : ((Object)$roleRef).hashCode());
        List<Subject> $subjects = this.getSubjects();
        result = result * 59 + ($subjects == null ? 43 : ((Object)$subjects).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

