/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.rbac;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleRef;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleRefFluent;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleRefFluentImpl;

public class RoleRefBuilder
extends RoleRefFluentImpl<RoleRefBuilder>
implements VisitableBuilder<RoleRef, RoleRefBuilder> {
    RoleRefFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RoleRefBuilder() {
        this(true);
    }

    public RoleRefBuilder(Boolean validationEnabled) {
        this(new RoleRef(), validationEnabled);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RoleRef(), validationEnabled);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent, RoleRef instance) {
        this(fluent, instance, true);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent, RoleRef instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public RoleRefBuilder(RoleRef instance) {
        this(instance, (Boolean)true);
    }

    public RoleRefBuilder(RoleRef instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public RoleRefBuilder(Validator validator) {
        this(new RoleRef(), (Boolean)true);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent, RoleRef instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RoleRefBuilder(RoleRef instance, Validator validator) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public RoleRef build() {
        RoleRef buildable = new RoleRef(this.fluent.getApiGroup(), this.fluent.getKind(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleRefBuilder that = (RoleRefBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

