/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.settings;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.settings.PodPreset;
import io.dekorate.deps.kubernetes.api.model.settings.PodPresetFluent;
import io.dekorate.deps.kubernetes.api.model.settings.PodPresetFluentImpl;

public class PodPresetBuilder
extends PodPresetFluentImpl<PodPresetBuilder>
implements VisitableBuilder<PodPreset, PodPresetBuilder> {
    PodPresetFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodPresetBuilder() {
        this(true);
    }

    public PodPresetBuilder(Boolean validationEnabled) {
        this(new PodPreset(), validationEnabled);
    }

    public PodPresetBuilder(PodPresetFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodPresetBuilder(PodPresetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodPreset(), validationEnabled);
    }

    public PodPresetBuilder(PodPresetFluent<?> fluent, PodPreset instance) {
        this(fluent, instance, true);
    }

    public PodPresetBuilder(PodPresetFluent<?> fluent, PodPreset instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public PodPresetBuilder(PodPreset instance) {
        this(instance, (Boolean)true);
    }

    public PodPresetBuilder(PodPreset instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public PodPresetBuilder(Validator validator) {
        this(new PodPreset(), (Boolean)true);
    }

    public PodPresetBuilder(PodPresetFluent<?> fluent, PodPreset instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodPresetBuilder(PodPreset instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PodPreset build() {
        PodPreset buildable = new PodPreset(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodPresetBuilder that = (PodPresetBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

