/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.settings;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.settings.PodPresetSpec;
import io.dekorate.deps.kubernetes.api.model.settings.PodPresetSpecFluent;
import io.dekorate.deps.kubernetes.api.model.settings.PodPresetSpecFluentImpl;

public class PodPresetSpecBuilder
extends PodPresetSpecFluentImpl<PodPresetSpecBuilder>
implements VisitableBuilder<PodPresetSpec, PodPresetSpecBuilder> {
    PodPresetSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodPresetSpecBuilder() {
        this(true);
    }

    public PodPresetSpecBuilder(Boolean validationEnabled) {
        this(new PodPresetSpec(), validationEnabled);
    }

    public PodPresetSpecBuilder(PodPresetSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodPresetSpecBuilder(PodPresetSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodPresetSpec(), validationEnabled);
    }

    public PodPresetSpecBuilder(PodPresetSpecFluent<?> fluent, PodPresetSpec instance) {
        this(fluent, instance, true);
    }

    public PodPresetSpecBuilder(PodPresetSpecFluent<?> fluent, PodPresetSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEnv(instance.getEnv());
        fluent.withEnvFrom(instance.getEnvFrom());
        fluent.withSelector(instance.getSelector());
        fluent.withVolumeMounts(instance.getVolumeMounts());
        fluent.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    public PodPresetSpecBuilder(PodPresetSpec instance) {
        this(instance, (Boolean)true);
    }

    public PodPresetSpecBuilder(PodPresetSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEnv(instance.getEnv());
        this.withEnvFrom(instance.getEnvFrom());
        this.withSelector(instance.getSelector());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    public PodPresetSpecBuilder(Validator validator) {
        this(new PodPresetSpec(), (Boolean)true);
    }

    public PodPresetSpecBuilder(PodPresetSpecFluent<?> fluent, PodPresetSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withEnv(instance.getEnv());
        fluent.withEnvFrom(instance.getEnvFrom());
        fluent.withSelector(instance.getSelector());
        fluent.withVolumeMounts(instance.getVolumeMounts());
        fluent.withVolumes(instance.getVolumes());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodPresetSpecBuilder(PodPresetSpec instance, Validator validator) {
        this.fluent = this;
        this.withEnv(instance.getEnv());
        this.withEnvFrom(instance.getEnvFrom());
        this.withSelector(instance.getSelector());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withVolumes(instance.getVolumes());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PodPresetSpec build() {
        PodPresetSpec buildable = new PodPresetSpec(this.fluent.getEnv(), this.fluent.getEnvFrom(), this.fluent.getSelector(), this.fluent.getVolumeMounts(), this.fluent.getVolumes());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodPresetSpecBuilder that = (PodPresetSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

