/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.dsl.base;

import io.dekorate.deps.jackson.core.JsonParseException;
import io.dekorate.deps.jackson.core.type.TypeReference;
import io.dekorate.deps.jackson.databind.JsonNode;
import io.dekorate.deps.jackson.databind.ObjectMapper;
import io.dekorate.deps.kubernetes.api.model.DeleteOptions;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.Status;
import io.dekorate.deps.kubernetes.api.model.StatusBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.kubernetes.client.internal.PatchUtils;
import io.dekorate.deps.kubernetes.client.utils.Serialization;
import io.dekorate.deps.kubernetes.client.utils.URLUtils;
import io.dekorate.deps.kubernetes.client.utils.Utils;
import io.dekorate.deps.okhttp3.MediaType;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.okhttp3.Request;
import io.dekorate.deps.okhttp3.RequestBody;
import io.dekorate.deps.okhttp3.Response;
import io.dekorate.deps.okhttp3.ResponseBody;
import io.dekorate.deps.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class OperationSupport {
    public static final MediaType JSON = MediaType.parse("application/json");
    public static final MediaType JSON_PATCH = MediaType.parse("application/json-patch+json");
    protected static final ObjectMapper JSON_MAPPER = Serialization.jsonMapper();
    protected static final ObjectMapper YAML_MAPPER = Serialization.yamlMapper();
    private static final String CLIENT_STATUS_FLAG = "CLIENT_STATUS_FLAG";
    protected OperationContext context;
    protected final OkHttpClient client;
    protected final Config config;
    protected final String resourceT;
    protected String namespace;
    protected String name;
    protected String apiGroupName;
    protected String apiGroupVersion;

    public OperationSupport() {
        this(new OperationContext());
    }

    public OperationSupport(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public OperationSupport(OkHttpClient client, Config config, String namespace) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace));
    }

    public OperationSupport(OperationContext ctx) {
        this.context = ctx;
        this.client = ctx.getClient();
        this.config = ctx.getConfig();
        this.resourceT = ctx.getPlural();
        this.namespace = ctx.getNamespace();
        this.name = ctx.getName();
        this.apiGroupName = ctx.getApiGroupName();
        this.apiGroupVersion = ctx.getApiGroupVersion() != null ? ctx.getApiGroupVersion() : (ctx.getConfig() != null ? ctx.getConfig().getApiVersion() : "v1");
    }

    public String getAPIGroup() {
        return this.apiGroupName;
    }

    public String getAPIVersion() {
        return this.apiGroupVersion;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    public URL getRootUrl() {
        try {
            if (!Utils.isNullOrEmpty(this.apiGroupName)) {
                return new URL(URLUtils.join(this.config.getMasterUrl().toString(), "apis", this.apiGroupName, this.apiGroupVersion));
            }
            return new URL(URLUtils.join(this.config.getMasterUrl().toString(), "api", this.apiGroupVersion));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public URL getNamespacedUrl(String namespace) throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.isResourceNamespaced() && Utils.isNotNullOrEmpty(namespace)) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), "namespaces", namespace));
        }
        requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.resourceT));
        return requestUrl;
    }

    public URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    public <T> URL getNamespacedUrl(T item) throws MalformedURLException {
        return this.getNamespacedUrl(this.checkNamespace(item));
    }

    public URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        if (name == null) {
            return this.getNamespacedUrl(namespace);
        }
        return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name));
    }

    public URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(URLUtils.join(this.getNamespacedUrl().toString(), this.name));
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata && ((HasMetadata)item).getMetadata() != null ? ((HasMetadata)item).getMetadata().getNamespace() : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            if (!this.isResourceNamespaced()) {
                return null;
            }
            throw new KubernetesClientException("Namespace not specified. But operation requires namespace.");
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty(operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    protected <T> String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        String string = itemName = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata().getName() : null;
        if (Utils.isNullOrEmpty(operationName) && Utils.isNullOrEmpty(itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty(operationName)) {
            return itemName;
        }
        if (itemName.equals(operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected <T> void handleDelete(T resource, long gracePeriodSeconds, boolean cascading) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        this.handleDelete(this.getResourceUrl(this.checkNamespace(resource), this.checkName(resource)), gracePeriodSeconds, cascading);
    }

    protected void handleDelete(URL requestUrl, long gracePeriodSeconds, boolean cascading) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        RequestBody requestBody = null;
        DeleteOptions deleteOptions = new DeleteOptions();
        deleteOptions.setOrphanDependents(!cascading);
        if (gracePeriodSeconds >= 0L) {
            deleteOptions.setGracePeriodSeconds(gracePeriodSeconds);
        }
        requestBody = RequestBody.create(JSON, JSON_MAPPER.writeValueAsString(deleteOptions));
        Request.Builder requestBuilder = new Request.Builder().delete(requestBody).url(requestUrl);
        this.handleResponse(requestBuilder, null, Collections.emptyMap());
    }

    protected <T, I> T handleCreate(I resource, Class<T> outputType) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        RequestBody body = RequestBody.create(JSON, JSON_MAPPER.writeValueAsString(resource));
        Request.Builder requestBuilder = new Request.Builder().post(body).url(this.getNamespacedUrl(this.checkNamespace(resource)));
        return this.handleResponse(requestBuilder, outputType, Collections.emptyMap());
    }

    protected <T> T handleReplace(T updated, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleReplace(updated, type, Collections.emptyMap());
    }

    protected <T> T handleReplace(T updated, Class<T> type, Map<String, String> parameters) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        RequestBody body = RequestBody.create(JSON, JSON_MAPPER.writeValueAsString(updated));
        Request.Builder requestBuilder = new Request.Builder().put(body).url(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated)));
        return this.handleResponse(requestBuilder, type, parameters);
    }

    protected <T> T handlePatch(T current, T updated, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        JsonNode diff = JsonDiff.asJson(PatchUtils.patchMapper().valueToTree(current), PatchUtils.patchMapper().valueToTree(updated));
        RequestBody body = RequestBody.create(JSON_PATCH, JSON_MAPPER.writeValueAsString(diff));
        Request.Builder requestBuilder = new Request.Builder().patch(body).url(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated)));
        return this.handleResponse(requestBuilder, type, Collections.emptyMap());
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleGet(resourceUrl, type, Collections.emptyMap());
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type, Map<String, String> parameters) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().get().url(resourceUrl);
        return this.handleResponse(requestBuilder, type, parameters);
    }

    protected <T> T handleResponse(Request.Builder requestBuilder, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleResponse(requestBuilder, type, Collections.emptyMap());
    }

    protected <T> T handleResponse(Request.Builder requestBuilder, Class<T> type, Map<String, String> parameters) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleResponse(this.client, requestBuilder, type, parameters);
    }

    protected <T> T handleResponse(OkHttpClient client, Request.Builder requestBuilder, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleResponse(client, requestBuilder, type, Collections.emptyMap());
    }

    /*
     * Exception decompiling
     */
    protected <T> T handleResponse(OkHttpClient client, Request.Builder requestBuilder, Class<T> type, Map<String, String> parameters) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 36[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void assertResponseCode(Request request, Response response) {
        int statusCode = response.code();
        String customMessage = this.config.getErrorMessages().get(statusCode);
        if (response.isSuccessful()) {
            return;
        }
        if (customMessage != null) {
            throw OperationSupport.requestFailure(request, OperationSupport.createStatus(statusCode, this.combineMessages(customMessage, OperationSupport.createStatus(response))));
        }
        throw OperationSupport.requestFailure(request, OperationSupport.createStatus(response));
    }

    private String combineMessages(String customMessage, Status defaultStatus) {
        String message;
        if (defaultStatus != null && (message = defaultStatus.getMessage()) != null && message.length() > 0) {
            return customMessage + " " + message;
        }
        return customMessage;
    }

    public static Status createStatus(Response response) {
        String statusMessage = "";
        ResponseBody body = response != null ? response.body() : null;
        int statusCode = response != null ? response.code() : 0;
        try {
            if (response == null) {
                statusMessage = "No response";
            } else if (body != null) {
                statusMessage = body.string();
            } else if (response.message() != null) {
                statusMessage = response.message();
            }
            Status status = JSON_MAPPER.readValue(statusMessage, Status.class);
            if (status.getCode() == null) {
                status = ((StatusBuilder)new StatusBuilder(status).withCode(statusCode)).build();
            }
            return status;
        }
        catch (JsonParseException e) {
            return OperationSupport.createStatus(statusCode, statusMessage);
        }
        catch (IOException e) {
            return OperationSupport.createStatus(statusCode, statusMessage);
        }
    }

    public static Status createStatus(int statusCode, String message) {
        Status status = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(statusCode)).withMessage(message)).build();
        status.getAdditionalProperties().put(CLIENT_STATUS_FLAG, "true");
        return status;
    }

    public static KubernetesClientException requestFailure(Request request, Status status) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failure executing: ").append(request.method()).append(" at: ").append(request.url().toString()).append(".");
        if (status.getMessage() != null && !status.getMessage().isEmpty()) {
            sb.append(" Message: ").append(status.getMessage()).append(".");
        }
        if (status != null && !status.getAdditionalProperties().containsKey(CLIENT_STATUS_FLAG)) {
            sb.append(" Received status: ").append(status).append(".");
        }
        return new KubernetesClientException(sb.toString(), status.getCode(), status);
    }

    public static KubernetesClientException requestException(Request request, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error executing: ").append(request.method()).append(" at: ").append(request.url().toString()).append(". Cause: ").append(e.getMessage());
        return new KubernetesClientException(sb.toString(), e);
    }

    protected static <T> T unmarshal(InputStream is) throws KubernetesClientException {
        return Serialization.unmarshal(is);
    }

    protected static <T> T unmarshal(InputStream is, Class<T> type) throws KubernetesClientException {
        return Serialization.unmarshal(is, type);
    }

    protected static <T> T unmarshal(InputStream is, TypeReference<T> type) throws KubernetesClientException {
        return Serialization.unmarshal(is, type);
    }

    public Config getConfig() {
        return this.config;
    }
}

