/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.dsl.internal;

import io.dekorate.deps.kubernetes.api.model.batch.DoneableJob;
import io.dekorate.deps.kubernetes.api.model.batch.Job;
import io.dekorate.deps.kubernetes.api.model.batch.JobFluent;
import io.dekorate.deps.kubernetes.api.model.batch.JobList;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.dsl.Reaper;
import io.dekorate.deps.kubernetes.client.dsl.ScalableResource;
import io.dekorate.deps.kubernetes.client.dsl.base.HasMetadataOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.org.slf4j.Logger;
import io.dekorate.deps.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class JobOperationsImpl
extends HasMetadataOperation<Job, JobList, DoneableJob, ScalableResource<Job, DoneableJob>>
implements ScalableResource<Job, DoneableJob> {
    static final transient Logger LOG = LoggerFactory.getLogger(JobOperationsImpl.class);

    public JobOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public JobOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("batch").withApiGroupVersion("v1").withPlural("jobs"));
        this.type = Job.class;
        this.listType = JobList.class;
        this.doneableType = DoneableJob.class;
    }

    public JobOperationsImpl newInstance(OperationContext context) {
        return new JobOperationsImpl(context);
    }

    @Override
    public ScalableResource<Job, DoneableJob> load(InputStream is) {
        try {
            Job item = JobOperationsImpl.unmarshal(is, Job.class);
            return new JobOperationsImpl(this.context.withItem(item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ScalableResource<Job, DoneableJob> fromServer() {
        return new JobOperationsImpl(this.context.withReloadingFromServer(true));
    }

    @Override
    public Job scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Job scale(int count, boolean wait) {
        Job res = ((DoneableJob)((JobFluent.SpecNested)((DoneableJob)this.cascading(false).edit()).editSpec().withParallelism(count)).endSpec()).done();
        if (wait) {
            this.waitUntilJobIsScaled();
            res = (Job)this.getMandatory();
        }
        return res;
    }

    private void waitUntilJobIsScaled() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference atomicJob = new AtomicReference();
        Runnable jobPoller = () -> {
            try {
                Job job = (Job)this.getMandatory();
                atomicJob.set(job);
                Integer activeJobs = job.getStatus().getActive();
                if (activeJobs == null) {
                    activeJobs = 0;
                }
                if (Objects.equals(job.getSpec().getParallelism(), activeJobs)) {
                    countDownLatch.countDown();
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Job: {} in namespace: {} seconds so waiting...", job.getStatus().getActive(), job.getSpec().getParallelism(), job.getMetadata().getName(), this.namespace);
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Job to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(jobPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            poller.cancel(true);
            executor.shutdown();
            LOG.error("Only {}/{} pod(s) ready for Job: {} in namespace: {} - giving up", ((Job)atomicJob.get()).getStatus().getActive(), ((Job)atomicJob.get()).getSpec().getParallelism(), ((Job)atomicJob.get()).getMetadata().getName(), this.namespace);
        }
    }

    private static class JobReaper
    implements Reaper {
        private JobOperationsImpl oper;

        public JobReaper(JobOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public boolean reap() {
            this.oper.scale(0, true);
            return false;
        }
    }
}

