/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.Namespace;
import io.dekorate.deps.kubernetes.api.model.NamespaceBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.internal.NamespaceOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class NamespaceHandler
implements ResourceHandler<Namespace, NamespaceBuilder> {
    @Override
    public String getKind() {
        return Namespace.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Namespace create(OkHttpClient client, Config config, String namespace, Namespace item) {
        return (Namespace)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Namespace[0]);
    }

    @Override
    public Namespace replace(OkHttpClient client, Config config, String namespace, Namespace item) {
        return (Namespace)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Namespace reload(OkHttpClient client, Config config, String namespace, Namespace item) {
        return (Namespace)((Gettable)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NamespaceBuilder edit(Namespace item) {
        return new NamespaceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Namespace item) {
        return (Boolean)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Namespace item, Watcher<Namespace> watcher) {
        return (Watch)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Namespace item, String resourceVersion, Watcher<Namespace> watcher) {
        return (Watch)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Namespace waitUntilReady(OkHttpClient client, Config config, String namespace, Namespace item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Namespace)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Namespace waitUntilCondition(OkHttpClient client, Config config, String namespace, Namespace item, Predicate<Namespace> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Namespace)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

