/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.ResourceQuota;
import io.dekorate.deps.kubernetes.api.model.ResourceQuotaBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.internal.ResourceQuotaOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ResourceQuotaHandler
implements ResourceHandler<ResourceQuota, ResourceQuotaBuilder> {
    @Override
    public String getKind() {
        return ResourceQuota.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public ResourceQuota create(OkHttpClient client, Config config, String namespace, ResourceQuota item) {
        return (ResourceQuota)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new ResourceQuota[0]);
    }

    @Override
    public ResourceQuota replace(OkHttpClient client, Config config, String namespace, ResourceQuota item) {
        return (ResourceQuota)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ResourceQuota reload(OkHttpClient client, Config config, String namespace, ResourceQuota item) {
        return (ResourceQuota)((Gettable)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ResourceQuotaBuilder edit(ResourceQuota item) {
        return new ResourceQuotaBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, ResourceQuota item) {
        return (Boolean)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ResourceQuota item, Watcher<ResourceQuota> watcher) {
        return (Watch)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ResourceQuota item, String resourceVersion, Watcher<ResourceQuota> watcher) {
        return (Watch)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public ResourceQuota waitUntilReady(OkHttpClient client, Config config, String namespace, ResourceQuota item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ResourceQuota)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ResourceQuota waitUntilCondition(OkHttpClient client, Config config, String namespace, ResourceQuota item, Predicate<ResourceQuota> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ResourceQuota)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

