/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.rbac.RoleBinding;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.internal.RoleBindingOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class RoleBindingHandler
implements ResourceHandler<RoleBinding, RoleBindingBuilder> {
    @Override
    public String getKind() {
        return RoleBinding.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
    }

    @Override
    public RoleBinding create(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (RoleBinding)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new RoleBinding[0]);
    }

    @Override
    public RoleBinding replace(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (RoleBinding)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public RoleBinding reload(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (RoleBinding)((Gettable)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public RoleBindingBuilder edit(RoleBinding item) {
        return new RoleBindingBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (Boolean)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, RoleBinding item, Watcher<RoleBinding> watcher) {
        return (Watch)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, RoleBinding item, String resourceVersion, Watcher<RoleBinding> watcher) {
        return (Watch)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public RoleBinding waitUntilReady(OkHttpClient client, Config config, String namespace, RoleBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (RoleBinding)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public RoleBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, RoleBinding item, Predicate<RoleBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (RoleBinding)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

