/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.internal;

import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.internal.PKCS1Util;
import io.dekorate.deps.kubernetes.client.utils.Utils;
import io.dekorate.deps.okio.ByteString;
import io.dekorate.deps.org.slf4j.Logger;
import io.dekorate.deps.org.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.concurrent.Callable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class CertUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CertUtils.class);
    public static String TRUST_STORE_SYSTEM_PROPERTY = "javax.net.ssl.trustStore";
    public static String TRUST_STORE_PASSWORD_SYSTEM_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static String KEY_STORE_SYSTEM_PROPERTY = "javax.net.ssl.keyStore";
    public static String KEY_STORE_PASSWORD_SYSTEM_PROPERTY = "javax.net.ssl.keyStorePassword";

    public static InputStream getInputStreamFromDataOrFile(String data, String file) throws IOException {
        if (data != null) {
            byte[] bytes = null;
            ByteString decoded = ByteString.decodeBase64(data);
            bytes = decoded != null ? decoded.toByteArray() : data.getBytes();
            return new ByteArrayInputStream(bytes);
        }
        if (file != null) {
            return new ByteArrayInputStream(new String(Files.readAllBytes(Paths.get(file, new String[0]))).trim().getBytes());
        }
        return null;
    }

    public static KeyStore createTrustStore(String caCertData, String caCertFile, String trustStoreFile, String trustStorePassphrase) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try (InputStream pemInputStream = CertUtils.getInputStreamFromDataOrFile(caCertData, caCertFile);){
            KeyStore keyStore = CertUtils.createTrustStore(pemInputStream, trustStoreFile, CertUtils.getTrustStorePassphrase(trustStorePassphrase));
            return keyStore;
        }
    }

    private static char[] getTrustStorePassphrase(String trustStorePassphrase) {
        if (Utils.isNullOrEmpty(trustStorePassphrase)) {
            return System.getProperty(TRUST_STORE_PASSWORD_SYSTEM_PROPERTY, "changeit").toCharArray();
        }
        return trustStorePassphrase.toCharArray();
    }

    public static KeyStore createTrustStore(InputStream pemInputStream, String trustStoreFile, char[] trustStorePassphrase) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        if (Utils.isNotNullOrEmpty(trustStoreFile)) {
            trustStore.load(new FileInputStream(trustStoreFile), trustStorePassphrase);
        } else {
            CertUtils.loadDefaultTrustStoreFile(trustStore, trustStorePassphrase);
        }
        while (pemInputStream.available() > 0) {
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(pemInputStream);
            String alias = cert.getSubjectX500Principal().getName();
            trustStore.setCertificateEntry(alias, cert);
        }
        return trustStore;
    }

    public static KeyStore createKeyStore(InputStream certInputStream, InputStream keyInputStream, String clientKeyAlgo, char[] clientKeyPassphrase, String keyStoreFile, char[] keyStorePassphrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(certInputStream);
        PrivateKey privateKey = CertUtils.loadKey(keyInputStream, clientKeyAlgo);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        if (Utils.isNotNullOrEmpty(keyStoreFile)) {
            keyStore.load(new FileInputStream(keyStoreFile), keyStorePassphrase);
        } else {
            CertUtils.loadDefaultKeyStoreFile(keyStore, keyStorePassphrase);
        }
        String alias = cert.getSubjectX500Principal().getName();
        keyStore.setKeyEntry(alias, privateKey, clientKeyPassphrase, new Certificate[]{cert});
        return keyStore;
    }

    private static PrivateKey loadKey(InputStream keyInputStream, String clientKeyAlgo) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        if (clientKeyAlgo == null) {
            clientKeyAlgo = "RSA";
        }
        if (clientKeyAlgo.equals("EC")) {
            return CertUtils.handleECKey(keyInputStream);
        }
        if (clientKeyAlgo.equals("RSA")) {
            return CertUtils.handleOtherKeys(keyInputStream, clientKeyAlgo);
        }
        throw new InvalidKeySpecException("Unknown type of PKCS8 Private Key, tried RSA and ECDSA");
    }

    private static PrivateKey handleECKey(final InputStream keyInputStream) throws IOException {
        try {
            return new Callable<PrivateKey>(){

                @Override
                public PrivateKey call() {
                    try {
                        Security.addProvider((Provider)new BouncyCastleProvider());
                        PEMKeyPair keys = (PEMKeyPair)new PEMParser((Reader)new InputStreamReader(keyInputStream)).readObject();
                        return new JcaPEMKeyConverter().getKeyPair(keys).getPrivate();
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                        return null;
                    }
                }
            }.call();
        }
        catch (NoClassDefFoundError e) {
            throw new KubernetesClientException("JcaPEMKeyConverter is provided by BouncyCastle, an optional dependency. To use support for EC Keys you must explicitly add this dependency to classpath.");
        }
    }

    private static PrivateKey handleOtherKeys(InputStream keyInputStream, String clientKeyAlgo) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = CertUtils.decodePem(keyInputStream);
        KeyFactory keyFactory = KeyFactory.getInstance(clientKeyAlgo);
        try {
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        }
        catch (InvalidKeySpecException e) {
            RSAPrivateCrtKeySpec keySpec = PKCS1Util.decodePKCS1(keyBytes);
            return keyFactory.generatePrivate(keySpec);
        }
    }

    private static void loadDefaultTrustStoreFile(KeyStore keyStore, char[] trustStorePassphrase) throws CertificateException, NoSuchAlgorithmException, IOException {
        File trustStoreFile = CertUtils.getDefaultTrustStoreFile();
        if (!CertUtils.loadDefaultStoreFile(keyStore, trustStoreFile, trustStorePassphrase)) {
            keyStore.load(null);
        }
    }

    private static File getDefaultTrustStoreFile() {
        String securityDirectory = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator;
        String trustStorePath = System.getProperty(TRUST_STORE_SYSTEM_PROPERTY);
        if (Utils.isNotNullOrEmpty(trustStorePath)) {
            return new File(trustStorePath);
        }
        File jssecacertsFile = new File(securityDirectory + "jssecacerts");
        if (jssecacertsFile.exists() && jssecacertsFile.isFile()) {
            return jssecacertsFile;
        }
        return new File(securityDirectory + "cacerts");
    }

    private static void loadDefaultKeyStoreFile(KeyStore keyStore, char[] keyStorePassphrase) throws CertificateException, NoSuchAlgorithmException, IOException {
        File keyStoreFile;
        String keyStorePath = System.getProperty(KEY_STORE_SYSTEM_PROPERTY);
        if (Utils.isNotNullOrEmpty(keyStorePath) && CertUtils.loadDefaultStoreFile(keyStore, keyStoreFile = new File(keyStorePath), keyStorePassphrase)) {
            return;
        }
        keyStore.load(null);
    }

    private static boolean loadDefaultStoreFile(KeyStore keyStore, File fileToLoad, char[] passphrase) throws CertificateException, NoSuchAlgorithmException, IOException {
        String notLoadedMessage = "There is a problem with reading default keystore/truststore file %s with the passphrase %s - the file won't be loaded. The reason is: %s";
        if (fileToLoad.exists() && fileToLoad.isFile() && fileToLoad.length() > 0L) {
            try {
                keyStore.load(new FileInputStream(fileToLoad), passphrase);
                return true;
            }
            catch (Exception e) {
                String passphraseToPrint = passphrase != null ? String.valueOf(passphrase) : null;
                LOG.info(String.format(notLoadedMessage, fileToLoad, passphraseToPrint, e.getMessage()));
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static KeyStore createKeyStore(String clientCertData, String clientCertFile, String clientKeyData, String clientKeyFile, String clientKeyAlgo, String clientKeyPassphrase, String keyStoreFile, String keyStorePassphrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static char[] getKeyStorePassphrase(String keyStorePassphrase) {
        if (Utils.isNullOrEmpty(keyStorePassphrase)) {
            return System.getProperty(KEY_STORE_PASSWORD_SYSTEM_PROPERTY, "changeit").toCharArray();
        }
        return keyStorePassphrase.toCharArray();
    }

    private static byte[] decodePem(InputStream keyInputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(keyInputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("-----BEGIN ")) continue;
                byte[] byArray = CertUtils.readBytes(reader, line.trim().replace("BEGIN", "END"));
                return byArray;
            }
            throw new IOException("PEM is invalid: no begin marker");
        }
    }

    private static byte[] readBytes(BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) {
                return ByteString.decodeBase64(buf.toString()).toByteArray();
            }
            buf.append(line.trim());
        }
        throw new IOException("PEM is invalid : No end marker");
    }
}

