/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.internal;

import io.dekorate.deps.org.slf4j.Logger;
import io.dekorate.deps.org.slf4j.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;

public final class VersionUsageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VersionUsageUtils.class);
    private static ConcurrentHashMap<String, Boolean> UNSTABLE_TYPES = new ConcurrentHashMap();
    private static final boolean LOG_EACH_USAGE = false;

    private VersionUsageUtils() {
    }

    public static void log(String type, String version) {
        if (type == null || version == null) {
            return;
        }
        if (VersionUsageUtils.isUnstable(version) && UNSTABLE_TYPES.putIfAbsent(type + "-" + version, true) == null) {
            VersionUsageUtils.alert(type, version);
        }
    }

    private static boolean isUnstable(String version) {
        String lowerCaseVersion = version.toLowerCase();
        return lowerCaseVersion.contains("beta") || lowerCaseVersion.contains("alpha");
    }

    private static void alert(String type, String version) {
        String message = "The client is using resource type '{}' with unstable version '{}'";
        if (type.equals("customresourcedefinitions") && version.equals("v1beta1")) {
            LOG.debug(message, (Object)type, (Object)version);
        } else {
            LOG.warn(message, (Object)type, (Object)version);
        }
    }
}

