/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.utils;

import io.dekorate.deps.jackson.core.JsonProcessingException;
import io.dekorate.deps.jackson.databind.ObjectMapper;
import io.dekorate.deps.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class IOHelpers {
    public static String readFully(InputStream in) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        return IOHelpers.readFully(r);
    }

    public static String readFully(Reader r) throws IOException {
        try (StringWriter w = new StringWriter();){
            IOHelpers.copy(r, w);
            String string = w.toString();
            return string;
        }
    }

    private static void copy(Reader reader, Writer writer) throws IOException {
        int len;
        char[] buffer = new char[8192];
        while ((len = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, len);
        }
        writer.flush();
    }

    public static boolean isJSONValid(String json) throws IOException {
        boolean valid = true;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            valid = false;
        }
        return valid;
    }

    public static String convertYamlToJson(String yaml) throws IOException {
        ObjectMapper yamlReader = new ObjectMapper(new YAMLFactory());
        Object obj = yamlReader.readValue(yaml, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        return jsonWriter.writeValueAsString(obj);
    }
}

