/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.utils;

import io.dekorate.deps.org.slf4j.Logger;
import io.dekorate.deps.org.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class IpAddressMatcher {
    private final InetAddress ipAddress;
    private final int bitMask;
    private final Logger logger = LoggerFactory.getLogger(IpAddressMatcher.class);

    public IpAddressMatcher(String ipAddress) {
        if (ipAddress.indexOf(47) > 0) {
            String[] addressWithMask = ipAddress.split("\\/");
            ipAddress = addressWithMask[0];
            this.bitMask = Integer.parseInt(addressWithMask[1]);
        } else {
            this.bitMask = -1;
        }
        this.ipAddress = this.parseAddress(ipAddress);
    }

    public boolean matches(String addressToCheck) {
        InetAddress checkAddress = this.parseAddress(addressToCheck);
        if (checkAddress == null) {
            return false;
        }
        if (this.ipAddress == null) {
            return false;
        }
        if (!this.ipAddress.getClass().equals(checkAddress.getClass())) {
            return false;
        }
        if (this.bitMask < 0) {
            return checkAddress.equals(this.ipAddress);
        }
        byte[] checkAddrBytes = checkAddress.getAddress();
        byte[] ipAddrBytes = this.ipAddress.getAddress();
        int oddBits = this.bitMask % 8;
        int maskBytes = this.bitMask / 8 + (oddBits == 0 ? 0 : 1);
        byte[] mask = new byte[maskBytes];
        Arrays.fill(mask, 0, oddBits == 0 ? mask.length : mask.length - 1, (byte)-1);
        if (oddBits != 0) {
            int lastByte = (1 << oddBits) - 1;
            mask[mask.length - 1] = (byte)(lastByte <<= 8 - oddBits);
        }
        for (int i = 0; i < mask.length; ++i) {
            if ((checkAddrBytes[i] & mask[i]) == (ipAddrBytes[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    private InetAddress parseAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            if (!"https://kubernetes.default.svc".contains(address)) {
                this.logger.error("Failed to resolve hostname: ", (Object)address);
            }
            return null;
        }
    }
}

