/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.utils;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.client.utils.Utils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class KubernetesResourceUtil {
    public static final Pattern KUBERNETES_DNS1123_LABEL_REGEX = Pattern.compile("[a-z0-9]([-a-z0-9]*[a-z0-9])?");
    public static final int KUBERNETES_DNS1123_LABEL_MAX_LENGTH = 63;

    public static String getResourceVersion(HasMetadata entity) {
        String resourceVersion;
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null && !Utils.isNullOrEmpty(resourceVersion = metadata.getResourceVersion())) {
            return resourceVersion;
        }
        return null;
    }

    public static String getKind(HasMetadata entity) {
        if (entity != null) {
            if (entity instanceof KubernetesList) {
                return "List";
            }
            return entity.getClass().getSimpleName();
        }
        return null;
    }

    public static String getQualifiedName(HasMetadata entity) {
        if (entity != null) {
            return "" + KubernetesResourceUtil.getNamespace(entity) + "/" + KubernetesResourceUtil.getName(entity);
        }
        return null;
    }

    public static String getName(HasMetadata entity) {
        if (entity != null) {
            return KubernetesResourceUtil.getName(entity.getMetadata());
        }
        return null;
    }

    public static boolean hasResourceVersion(HasMetadata entity) {
        return KubernetesResourceUtil.getResourceVersion(entity) != null;
    }

    public static String getName(ObjectMeta entity) {
        if (entity != null) {
            return Utils.coalesce(entity.getName(), KubernetesResourceUtil.getAdditionalPropertyText(entity.getAdditionalProperties(), "id"), entity.getUid());
        }
        return null;
    }

    protected static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public static String getNamespace(ObjectMeta entity) {
        if (entity != null) {
            return entity.getNamespace();
        }
        return null;
    }

    public static String getNamespace(HasMetadata entity) {
        if (entity != null) {
            return KubernetesResourceUtil.getNamespace(entity.getMetadata());
        }
        return null;
    }

    public static Map<String, String> getOrCreateAnnotations(HasMetadata entity) {
        ObjectMeta metadata = KubernetesResourceUtil.getOrCreateMetadata(entity);
        Map<String, String> answer = metadata.getAnnotations();
        if (answer == null) {
            answer = new LinkedHashMap<String, String>();
            metadata.setAnnotations(answer);
        }
        return answer;
    }

    public static String sanitizeName(String name) {
        if (name != null) {
            return name.replaceAll("[^A-Za-z0-9]+", "-");
        }
        return null;
    }

    public static Map<String, String> getOrCreateLabels(HasMetadata entity) {
        ObjectMeta metadata = KubernetesResourceUtil.getOrCreateMetadata(entity);
        Map<String, String> answer = metadata.getLabels();
        if (answer == null) {
            answer = new LinkedHashMap<String, String>();
            metadata.setLabels(answer);
        }
        return answer;
    }

    public static Map<String, String> getLabels(ObjectMeta metadata) {
        Map<String, String> labels;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            return labels;
        }
        return Collections.EMPTY_MAP;
    }

    public static ObjectMeta getOrCreateMetadata(HasMetadata entity) {
        ObjectMeta metadata = entity.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            entity.setMetadata(metadata);
        }
        return metadata;
    }

    public static boolean isValidName(String name) {
        return Utils.isNotNullOrEmpty(name) && name.length() < 63 && KUBERNETES_DNS1123_LABEL_REGEX.matcher(name).matches();
    }

    public static boolean isValidLabelOrAnnotation(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (KubernetesResourceUtil.isValidName(entry.getKey()) && KubernetesResourceUtil.isValidName(entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

