/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.BuildConfigList;
import io.dekorate.deps.openshift.api.model.BuildConfigListFluent;
import io.dekorate.deps.openshift.api.model.BuildConfigListFluentImpl;

public class BuildConfigListBuilder
extends BuildConfigListFluentImpl<BuildConfigListBuilder>
implements VisitableBuilder<BuildConfigList, BuildConfigListBuilder> {
    BuildConfigListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BuildConfigListBuilder() {
        this(true);
    }

    public BuildConfigListBuilder(Boolean validationEnabled) {
        this(new BuildConfigList(), validationEnabled);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildConfigList(), validationEnabled);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent, BuildConfigList instance) {
        this(fluent, instance, true);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent, BuildConfigList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigListBuilder(BuildConfigList instance) {
        this(instance, (Boolean)true);
    }

    public BuildConfigListBuilder(BuildConfigList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigListBuilder(Validator validator) {
        this(new BuildConfigList(), (Boolean)true);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent, BuildConfigList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BuildConfigListBuilder(BuildConfigList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public BuildConfigList build() {
        BuildConfigList buildable = new BuildConfigList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigListBuilder that = (BuildConfigListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

