/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.BuildConfigSpec;
import io.dekorate.deps.openshift.api.model.BuildConfigSpecFluent;
import io.dekorate.deps.openshift.api.model.BuildConfigSpecFluentImpl;

public class BuildConfigSpecBuilder
extends BuildConfigSpecFluentImpl<BuildConfigSpecBuilder>
implements VisitableBuilder<BuildConfigSpec, BuildConfigSpecBuilder> {
    BuildConfigSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BuildConfigSpecBuilder() {
        this(true);
    }

    public BuildConfigSpecBuilder(Boolean validationEnabled) {
        this(new BuildConfigSpec(), validationEnabled);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildConfigSpec(), validationEnabled);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, BuildConfigSpec instance) {
        this(fluent, instance, true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, BuildConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        fluent.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withOutput(instance.getOutput());
        fluent.withPostCommit(instance.getPostCommit());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withRunPolicy(instance.getRunPolicy());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
        fluent.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
        fluent.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigSpecBuilder(BuildConfigSpec instance) {
        this(instance, (Boolean)true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withRunPolicy(instance.getRunPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
        this.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigSpecBuilder(Validator validator) {
        this(new BuildConfigSpec(), (Boolean)true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, BuildConfigSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        fluent.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withOutput(instance.getOutput());
        fluent.withPostCommit(instance.getPostCommit());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withRunPolicy(instance.getRunPolicy());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
        fluent.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
        fluent.withTriggers(instance.getTriggers());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BuildConfigSpecBuilder(BuildConfigSpec instance, Validator validator) {
        this.fluent = this;
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withRunPolicy(instance.getRunPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
        this.withTriggers(instance.getTriggers());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public BuildConfigSpec build() {
        BuildConfigSpec buildable = new BuildConfigSpec(this.fluent.getCompletionDeadlineSeconds(), this.fluent.getFailedBuildsHistoryLimit(), this.fluent.getNodeSelector(), this.fluent.getOutput(), this.fluent.getPostCommit(), this.fluent.getResources(), this.fluent.getRevision(), this.fluent.getRunPolicy(), this.fluent.getServiceAccount(), this.fluent.getSource(), this.fluent.getStrategy(), this.fluent.getSuccessfulBuildsHistoryLimit(), this.fluent.getTriggers());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigSpecBuilder that = (BuildConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

