/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.BuildStrategy;
import io.dekorate.deps.openshift.api.model.BuildStrategyFluent;
import io.dekorate.deps.openshift.api.model.BuildStrategyFluentImpl;

public class BuildStrategyBuilder
extends BuildStrategyFluentImpl<BuildStrategyBuilder>
implements VisitableBuilder<BuildStrategy, BuildStrategyBuilder> {
    BuildStrategyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BuildStrategyBuilder() {
        this(true);
    }

    public BuildStrategyBuilder(Boolean validationEnabled) {
        this(new BuildStrategy(), validationEnabled);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildStrategy(), validationEnabled);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, BuildStrategy instance) {
        this(fluent, instance, true);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, BuildStrategy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCustomStrategy(instance.getCustomStrategy());
        fluent.withDockerStrategy(instance.getDockerStrategy());
        fluent.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
        fluent.withSourceStrategy(instance.getSourceStrategy());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public BuildStrategyBuilder(BuildStrategy instance) {
        this(instance, (Boolean)true);
    }

    public BuildStrategyBuilder(BuildStrategy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCustomStrategy(instance.getCustomStrategy());
        this.withDockerStrategy(instance.getDockerStrategy());
        this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
        this.withSourceStrategy(instance.getSourceStrategy());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public BuildStrategyBuilder(Validator validator) {
        this(new BuildStrategy(), (Boolean)true);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, BuildStrategy instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCustomStrategy(instance.getCustomStrategy());
        fluent.withDockerStrategy(instance.getDockerStrategy());
        fluent.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
        fluent.withSourceStrategy(instance.getSourceStrategy());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BuildStrategyBuilder(BuildStrategy instance, Validator validator) {
        this.fluent = this;
        this.withCustomStrategy(instance.getCustomStrategy());
        this.withDockerStrategy(instance.getDockerStrategy());
        this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
        this.withSourceStrategy(instance.getSourceStrategy());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public BuildStrategy build() {
        BuildStrategy buildable = new BuildStrategy(this.fluent.getCustomStrategy(), this.fluent.getDockerStrategy(), this.fluent.getJenkinsPipelineStrategy(), this.fluent.getSourceStrategy(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildStrategyBuilder that = (BuildStrategyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

