/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.Group;
import io.dekorate.deps.openshift.api.model.GroupFluent;
import io.dekorate.deps.openshift.api.model.GroupFluentImpl;

public class GroupBuilder
extends GroupFluentImpl<GroupBuilder>
implements VisitableBuilder<Group, GroupBuilder> {
    GroupFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GroupBuilder() {
        this(true);
    }

    public GroupBuilder(Boolean validationEnabled) {
        this(new Group(), validationEnabled);
    }

    public GroupBuilder(GroupFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GroupBuilder(GroupFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Group(), validationEnabled);
    }

    public GroupBuilder(GroupFluent<?> fluent, Group instance) {
        this(fluent, instance, true);
    }

    public GroupBuilder(GroupFluent<?> fluent, Group instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withUsers(instance.getUsers());
        this.validationEnabled = validationEnabled;
    }

    public GroupBuilder(Group instance) {
        this(instance, (Boolean)true);
    }

    public GroupBuilder(Group instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withUsers(instance.getUsers());
        this.validationEnabled = validationEnabled;
    }

    public GroupBuilder(Validator validator) {
        this(new Group(), (Boolean)true);
    }

    public GroupBuilder(GroupFluent<?> fluent, Group instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withUsers(instance.getUsers());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public GroupBuilder(Group instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withUsers(instance.getUsers());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Group build() {
        Group buildable = new Group(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getUsers());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupBuilder that = (GroupBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

