/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaFluentImpl;
import io.dekorate.deps.kubernetes.api.model.ObjectReference;
import io.dekorate.deps.kubernetes.api.model.ObjectReferenceBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.dekorate.deps.openshift.api.model.Identity;
import io.dekorate.deps.openshift.api.model.IdentityFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class IdentityFluentImpl<A extends IdentityFluent<A>>
extends BaseFluent<A>
implements IdentityFluent<A> {
    private String apiVersion;
    private Map<String, String> extra;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String providerName;
    private String providerUserName;
    private ObjectReferenceBuilder user;

    public IdentityFluentImpl() {
    }

    public IdentityFluentImpl(Identity instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withExtra(instance.getExtra());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withProviderName(instance.getProviderName());
        this.withProviderUserName(instance.getProviderUserName());
        this.withUser(instance.getUser());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToExtra(String key, String value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, String> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, String> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getExtra() {
        return this.extra;
    }

    @Override
    public A withExtra(Map<String, String> extra) {
        this.extra = extra == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(extra);
        return (A)this;
    }

    @Override
    public Boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public IdentityFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public IdentityFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public IdentityFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public IdentityFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public IdentityFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public A withProviderName(String providerName) {
        this.providerName = providerName;
        return (A)this;
    }

    @Override
    public Boolean hasProviderName() {
        return this.providerName != null;
    }

    @Override
    public A withNewProviderName(String arg1) {
        return this.withProviderName(new String(arg1));
    }

    @Override
    public A withNewProviderName(StringBuilder arg1) {
        return this.withProviderName(new String(arg1));
    }

    @Override
    public A withNewProviderName(StringBuffer arg1) {
        return this.withProviderName(new String(arg1));
    }

    @Override
    public String getProviderUserName() {
        return this.providerUserName;
    }

    @Override
    public A withProviderUserName(String providerUserName) {
        this.providerUserName = providerUserName;
        return (A)this;
    }

    @Override
    public Boolean hasProviderUserName() {
        return this.providerUserName != null;
    }

    @Override
    public A withNewProviderUserName(String arg1) {
        return this.withProviderUserName(new String(arg1));
    }

    @Override
    public A withNewProviderUserName(StringBuilder arg1) {
        return this.withProviderUserName(new String(arg1));
    }

    @Override
    public A withNewProviderUserName(StringBuffer arg1) {
        return this.withProviderUserName(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public ObjectReference buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(ObjectReference user) {
        this._visitables.get("user").remove(this.user);
        if (user != null) {
            this.user = new ObjectReferenceBuilder(user);
            this._visitables.get("user").add(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public IdentityFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public IdentityFluent.UserNested<A> withNewUserLike(ObjectReference item) {
        return new UserNestedImpl(item);
    }

    @Override
    public IdentityFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public IdentityFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new ObjectReferenceBuilder().build());
    }

    @Override
    public IdentityFluent.UserNested<A> editOrNewUserLike(ObjectReference item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityFluentImpl that = (IdentityFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.providerName != null ? !this.providerName.equals(that.providerName) : that.providerName != null) {
            return false;
        }
        if (this.providerUserName != null ? !this.providerUserName.equals(that.providerUserName) : that.providerUserName != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class UserNestedImpl<N>
    extends ObjectReferenceFluentImpl<IdentityFluent.UserNested<N>>
    implements IdentityFluent.UserNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        UserNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)IdentityFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<IdentityFluent.MetadataNested<N>>
    implements IdentityFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)IdentityFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

