/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.ImageLayer;
import io.dekorate.deps.openshift.api.model.ImageLayerFluent;
import io.dekorate.deps.openshift.api.model.ImageLayerFluentImpl;

public class ImageLayerBuilder
extends ImageLayerFluentImpl<ImageLayerBuilder>
implements VisitableBuilder<ImageLayer, ImageLayerBuilder> {
    ImageLayerFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ImageLayerBuilder() {
        this(true);
    }

    public ImageLayerBuilder(Boolean validationEnabled) {
        this(new ImageLayer(), validationEnabled);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageLayer(), validationEnabled);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent, ImageLayer instance) {
        this(fluent, instance, true);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent, ImageLayer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMediaType(instance.getMediaType());
        fluent.withName(instance.getName());
        fluent.withSize(instance.getSize());
        this.validationEnabled = validationEnabled;
    }

    public ImageLayerBuilder(ImageLayer instance) {
        this(instance, (Boolean)true);
    }

    public ImageLayerBuilder(ImageLayer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMediaType(instance.getMediaType());
        this.withName(instance.getName());
        this.withSize(instance.getSize());
        this.validationEnabled = validationEnabled;
    }

    public ImageLayerBuilder(Validator validator) {
        this(new ImageLayer(), (Boolean)true);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent, ImageLayer instance, Validator validator) {
        this.fluent = fluent;
        fluent.withMediaType(instance.getMediaType());
        fluent.withName(instance.getName());
        fluent.withSize(instance.getSize());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ImageLayerBuilder(ImageLayer instance, Validator validator) {
        this.fluent = this;
        this.withMediaType(instance.getMediaType());
        this.withName(instance.getName());
        this.withSize(instance.getSize());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ImageLayer build() {
        ImageLayer buildable = new ImageLayer(this.fluent.getMediaType(), this.fluent.getName(), this.fluent.getSize());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageLayerBuilder that = (ImageLayerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

