/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.ImageSource;
import io.dekorate.deps.openshift.api.model.ImageSourceFluent;
import io.dekorate.deps.openshift.api.model.ImageSourceFluentImpl;

public class ImageSourceBuilder
extends ImageSourceFluentImpl<ImageSourceBuilder>
implements VisitableBuilder<ImageSource, ImageSourceBuilder> {
    ImageSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ImageSourceBuilder() {
        this(true);
    }

    public ImageSourceBuilder(Boolean validationEnabled) {
        this(new ImageSource(), validationEnabled);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageSource(), validationEnabled);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent, ImageSource instance) {
        this(fluent, instance, true);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent, ImageSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAs(instance.getAs());
        fluent.withFrom(instance.getFrom());
        fluent.withPaths(instance.getPaths());
        fluent.withPullSecret(instance.getPullSecret());
        this.validationEnabled = validationEnabled;
    }

    public ImageSourceBuilder(ImageSource instance) {
        this(instance, (Boolean)true);
    }

    public ImageSourceBuilder(ImageSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAs(instance.getAs());
        this.withFrom(instance.getFrom());
        this.withPaths(instance.getPaths());
        this.withPullSecret(instance.getPullSecret());
        this.validationEnabled = validationEnabled;
    }

    public ImageSourceBuilder(Validator validator) {
        this(new ImageSource(), (Boolean)true);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent, ImageSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAs(instance.getAs());
        fluent.withFrom(instance.getFrom());
        fluent.withPaths(instance.getPaths());
        fluent.withPullSecret(instance.getPullSecret());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ImageSourceBuilder(ImageSource instance, Validator validator) {
        this.fluent = this;
        this.withAs(instance.getAs());
        this.withFrom(instance.getFrom());
        this.withPaths(instance.getPaths());
        this.withPullSecret(instance.getPullSecret());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ImageSource build() {
        ImageSource buildable = new ImageSource(this.fluent.getAs(), this.fluent.getFrom(), this.fluent.getPaths(), this.fluent.getPullSecret());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourceBuilder that = (ImageSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

