/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.ImageSourcePath;
import io.dekorate.deps.openshift.api.model.ImageSourcePathFluent;
import io.dekorate.deps.openshift.api.model.ImageSourcePathFluentImpl;

public class ImageSourcePathBuilder
extends ImageSourcePathFluentImpl<ImageSourcePathBuilder>
implements VisitableBuilder<ImageSourcePath, ImageSourcePathBuilder> {
    ImageSourcePathFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ImageSourcePathBuilder() {
        this(true);
    }

    public ImageSourcePathBuilder(Boolean validationEnabled) {
        this(new ImageSourcePath(), validationEnabled);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageSourcePath(), validationEnabled);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent, ImageSourcePath instance) {
        this(fluent, instance, true);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent, ImageSourcePath instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDestinationDir(instance.getDestinationDir());
        fluent.withSourcePath(instance.getSourcePath());
        this.validationEnabled = validationEnabled;
    }

    public ImageSourcePathBuilder(ImageSourcePath instance) {
        this(instance, (Boolean)true);
    }

    public ImageSourcePathBuilder(ImageSourcePath instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDestinationDir(instance.getDestinationDir());
        this.withSourcePath(instance.getSourcePath());
        this.validationEnabled = validationEnabled;
    }

    public ImageSourcePathBuilder(Validator validator) {
        this(new ImageSourcePath(), (Boolean)true);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent, ImageSourcePath instance, Validator validator) {
        this.fluent = fluent;
        fluent.withDestinationDir(instance.getDestinationDir());
        fluent.withSourcePath(instance.getSourcePath());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ImageSourcePathBuilder(ImageSourcePath instance, Validator validator) {
        this.fluent = this;
        this.withDestinationDir(instance.getDestinationDir());
        this.withSourcePath(instance.getSourcePath());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ImageSourcePath build() {
        ImageSourcePath buildable = new ImageSourcePath(this.fluent.getDestinationDir(), this.fluent.getSourcePath());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourcePathBuilder that = (ImageSourcePathBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

