/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.ImageStream;
import io.dekorate.deps.openshift.api.model.ImageStreamFluent;
import io.dekorate.deps.openshift.api.model.ImageStreamFluentImpl;

public class ImageStreamBuilder
extends ImageStreamFluentImpl<ImageStreamBuilder>
implements VisitableBuilder<ImageStream, ImageStreamBuilder> {
    ImageStreamFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ImageStreamBuilder() {
        this(true);
    }

    public ImageStreamBuilder(Boolean validationEnabled) {
        this(new ImageStream(), validationEnabled);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageStream(), validationEnabled);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent, ImageStream instance) {
        this(fluent, instance, true);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent, ImageStream instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamBuilder(ImageStream instance) {
        this(instance, (Boolean)true);
    }

    public ImageStreamBuilder(ImageStream instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamBuilder(Validator validator) {
        this(new ImageStream(), (Boolean)true);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent, ImageStream instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ImageStreamBuilder(ImageStream instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ImageStream build() {
        ImageStream buildable = new ImageStream(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamBuilder that = (ImageStreamBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

