/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.RoutePort;
import io.dekorate.deps.openshift.api.model.RoutePortFluent;
import io.dekorate.deps.openshift.api.model.RoutePortFluentImpl;

public class RoutePortBuilder
extends RoutePortFluentImpl<RoutePortBuilder>
implements VisitableBuilder<RoutePort, RoutePortBuilder> {
    RoutePortFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RoutePortBuilder() {
        this(true);
    }

    public RoutePortBuilder(Boolean validationEnabled) {
        this(new RoutePort(), validationEnabled);
    }

    public RoutePortBuilder(RoutePortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RoutePortBuilder(RoutePortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RoutePort(), validationEnabled);
    }

    public RoutePortBuilder(RoutePortFluent<?> fluent, RoutePort instance) {
        this(fluent, instance, true);
    }

    public RoutePortBuilder(RoutePortFluent<?> fluent, RoutePort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTargetPort(instance.getTargetPort());
        this.validationEnabled = validationEnabled;
    }

    public RoutePortBuilder(RoutePort instance) {
        this(instance, (Boolean)true);
    }

    public RoutePortBuilder(RoutePort instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTargetPort(instance.getTargetPort());
        this.validationEnabled = validationEnabled;
    }

    public RoutePortBuilder(Validator validator) {
        this(new RoutePort(), (Boolean)true);
    }

    public RoutePortBuilder(RoutePortFluent<?> fluent, RoutePort instance, Validator validator) {
        this.fluent = fluent;
        fluent.withTargetPort(instance.getTargetPort());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RoutePortBuilder(RoutePort instance, Validator validator) {
        this.fluent = this;
        this.withTargetPort(instance.getTargetPort());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public RoutePort build() {
        RoutePort buildable = new RoutePort(this.fluent.getTargetPort());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoutePortBuilder that = (RoutePortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

