/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.client.dsl.internal;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.dsl.FilterWatchListDeletable;
import io.dekorate.deps.kubernetes.client.dsl.Reaper;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.RollingOperationContext;
import io.dekorate.deps.kubernetes.client.utils.Utils;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.openshift.api.model.DeploymentConfig;
import io.dekorate.deps.openshift.api.model.DeploymentConfigFluent;
import io.dekorate.deps.openshift.api.model.DeploymentConfigList;
import io.dekorate.deps.openshift.api.model.DoneableDeploymentConfig;
import io.dekorate.deps.openshift.client.dsl.DeployableScalableResource;
import io.dekorate.deps.openshift.client.dsl.internal.OpenShiftOperation;
import io.dekorate.deps.org.slf4j.Logger;
import io.dekorate.deps.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class DeploymentConfigOperationsImpl
extends OpenShiftOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>>
implements DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentConfigOperationsImpl.class);
    private static final String DEPLOYMENT_CONFIG_REF = "openshift.io/deployment-config.name";

    public DeploymentConfigOperationsImpl(OkHttpClient client, Config config) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public DeploymentConfigOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps.openshift.io").withPlural("deploymentconfigs"));
        this.type = DeploymentConfig.class;
        this.listType = DeploymentConfigList.class;
        this.doneableType = DoneableDeploymentConfig.class;
        this.reaper = new DeploymentConfigReaper(this, this.client);
    }

    public DeploymentConfigOperationsImpl newInstance(OperationContext context) {
        return new DeploymentConfigOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public DoneableDeploymentConfig edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeploymentConfig)this.cascading(false).edit();
        }
        return (DoneableDeploymentConfig)super.edit();
    }

    @Override
    public DeploymentConfig replace(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public DeploymentConfig patch(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).patch(item);
        }
        return super.patch(item);
    }

    @Override
    public DeploymentConfig deployLatest() {
        return this.deployLatest(false);
    }

    @Override
    public DeploymentConfig deployLatest(boolean wait) {
        Long currentVersion = ((DeploymentConfig)this.getMandatory()).getStatus().getLatestVersion();
        if (currentVersion == null) {
            currentVersion = 1L;
        }
        currentVersion = currentVersion + 1L;
        DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.StatusNested)((DoneableDeploymentConfig)this.cascading(false).edit()).editStatus().withLatestVersion(currentVersion)).endStatus()).done();
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(deployment.getSpec().getReplicas());
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    @Override
    public DeploymentConfig scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public DeploymentConfig scale(int count, boolean wait) {
        DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(count);
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeploymentConfigIsScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable deploymentPoller = () -> {
            try {
                int currentReplicas;
                DeploymentConfig deploymentConfig = (DeploymentConfig)this.get();
                if (deploymentConfig == null) {
                    if (count == 0) {
                        queue.put(true);
                        return;
                    }
                    queue.put(new IllegalStateException("Can't wait for DeploymentConfig: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available."));
                    return;
                }
                replicasRef.set(deploymentConfig.getStatus().getReplicas());
                int n = currentReplicas = deploymentConfig.getStatus().getReplicas() != null ? deploymentConfig.getStatus().getReplicas() : 0;
                if (deploymentConfig.getStatus().getObservedGeneration() >= deploymentConfig.getMetadata().getGeneration() && Objects.equals(deploymentConfig.getSpec().getReplicas(), currentReplicas)) {
                    queue.put(true);
                } else {
                    LOG.debug("Only {}/{} pods scheduled for DeploymentConfig: {} in namespace: {} seconds so waiting...", deploymentConfig.getStatus().getReplicas(), deploymentConfig.getSpec().getReplicas(), deploymentConfig.getMetadata().getName(), namespace);
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Deployment to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.debug("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}.", replicasRef.get(), count, name, namespace);
            } else {
                LOG.error("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}  after waiting for {} seconds so giving up", replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout()));
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    private static class DeploymentConfigReaper
    implements Reaper {
        private final DeploymentConfigOperationsImpl operation;
        private final OkHttpClient client;

        public DeploymentConfigReaper(DeploymentConfigOperationsImpl operation, OkHttpClient client) {
            this.operation = operation;
            this.client = client;
        }

        @Override
        public boolean reap() {
            DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)this.operation.cascading(false).edit()).editSpec().withReplicas(0)).endSpec()).done();
            if (deployment.getStatus() != null) {
                this.waitForObservedGeneration(deployment.getStatus().getObservedGeneration());
            }
            Boolean reaped = (Boolean)this.operation.cascading(false).delete();
            this.waitForDeletion();
            HashMap<String, String> selector = new HashMap<String, String>();
            selector.put(DeploymentConfigOperationsImpl.DEPLOYMENT_CONFIG_REF, deployment.getMetadata().getName());
            if (selector != null && !selector.isEmpty()) {
                Boolean bl = (Boolean)((FilterWatchListDeletable)new ReplicationControllerOperationsImpl(this.client, this.operation.getConfig()).inNamespace(this.operation.namespace).withLabels(selector)).delete();
            }
            return reaped;
        }

        private void waitForObservedGeneration(long observedGeneration) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = () -> {
                DeploymentConfig deployment = (DeploymentConfig)this.operation.getMandatory();
                if (observedGeneration <= deployment.getStatus().getObservedGeneration()) {
                    countDownLatch.countDown();
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(1L, TimeUnit.MINUTES);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        private void waitForDeletion() {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = () -> {
                DeploymentConfig deployment = (DeploymentConfig)this.operation.get();
                if (deployment == null) {
                    countDownLatch.countDown();
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(1L, TimeUnit.MINUTES);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable(e);
            }
        }
    }
}

