/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.client.handlers;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.openshift.api.model.Build;
import io.dekorate.deps.openshift.api.model.BuildBuilder;
import io.dekorate.deps.openshift.client.OpenShiftConfig;
import io.dekorate.deps.openshift.client.dsl.BuildResource;
import io.dekorate.deps.openshift.client.dsl.internal.BuildOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class BuildHandler
implements ResourceHandler<Build, BuildBuilder> {
    @Override
    public String getKind() {
        return Build.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    @Override
    public Build create(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Build[0]);
    }

    @Override
    public Build replace(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Build reload(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)((Gettable)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public BuildBuilder edit(Build item) {
        return new BuildBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Build item) {
        return (Boolean)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Build item, Watcher<Build> watcher) {
        return (Watch)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Build item, String resourceVersion, Watcher<Build> watcher) {
        return (Watch)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Build waitUntilReady(OkHttpClient client, Config config, String namespace, Build item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Build waitUntilCondition(OkHttpClient client, Config config, String namespace, Build item, Predicate<Build> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

