/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.client.handlers;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.openshift.api.model.Image;
import io.dekorate.deps.openshift.api.model.ImageBuilder;
import io.dekorate.deps.openshift.client.OpenShiftConfig;
import io.dekorate.deps.openshift.client.dsl.internal.ImageOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ImageHandler
implements ResourceHandler<Image, ImageBuilder> {
    @Override
    public String getKind() {
        return Image.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    @Override
    public Image create(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Image[0]);
    }

    @Override
    public Image replace(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Image reload(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)((Gettable)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageBuilder edit(Image item) {
        return new ImageBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Image item) {
        return (Boolean)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, Watcher<Image> watcher) {
        return (Watch)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, String resourceVersion, Watcher<Image> watcher) {
        return (Watch)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Image waitUntilReady(OkHttpClient client, Config config, String namespace, Image item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Image waitUntilCondition(OkHttpClient client, Config config, String namespace, Image item, Predicate<Image> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

