/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.client.handlers;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.openshift.api.model.ImageStream;
import io.dekorate.deps.openshift.api.model.ImageStreamBuilder;
import io.dekorate.deps.openshift.client.OpenShiftConfig;
import io.dekorate.deps.openshift.client.dsl.internal.ImageStreamOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ImageStreamHandler
implements ResourceHandler<ImageStream, ImageStreamBuilder> {
    @Override
    public String getKind() {
        return ImageStream.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    @Override
    public ImageStream create(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new ImageStream[0]);
    }

    @Override
    public ImageStream replace(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ImageStream reload(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)((Gettable)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageStreamBuilder edit(ImageStream item) {
        return new ImageStreamBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (Boolean)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, Watcher<ImageStream> watcher) {
        return (Watch)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, String resourceVersion, Watcher<ImageStream> watcher) {
        return (Watch)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public ImageStream waitUntilReady(OkHttpClient client, Config config, String namespace, ImageStream item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ImageStream waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageStream item, Predicate<ImageStream> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

