/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.client.handlers;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.servicecatalog.api.client.internal.ServiceBindingOperationsImpl;
import io.dekorate.deps.servicecatalog.api.client.internal.ServiceBindingResource;
import io.dekorate.deps.servicecatalog.api.model.ServiceBinding;
import io.dekorate.deps.servicecatalog.api.model.ServiceBindingBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ServiceBindingHandler
implements ResourceHandler<ServiceBinding, ServiceBindingBuilder> {
    @Override
    public String getKind() {
        return ServiceBinding.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "servicecatalog.k8s.io/v1beta1";
    }

    @Override
    public ServiceBinding create(OkHttpClient client, Config config, String namespace, ServiceBinding item) {
        return (ServiceBinding)new ServiceBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new ServiceBinding[0]);
    }

    @Override
    public ServiceBinding replace(OkHttpClient client, Config config, String namespace, ServiceBinding item) {
        return (ServiceBinding)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ServiceBinding reload(OkHttpClient client, Config config, String namespace, ServiceBinding item) {
        return (ServiceBinding)((Gettable)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ServiceBindingBuilder edit(ServiceBinding item) {
        return new ServiceBindingBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, ServiceBinding item) {
        return (Boolean)new ServiceBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceBinding item, Watcher<ServiceBinding> watcher) {
        return (Watch)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceBinding item, String resourceVersion, Watcher<ServiceBinding> watcher) {
        return (Watch)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public ServiceBinding waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceBinding)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ServiceBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceBinding item, Predicate<ServiceBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceBinding)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

