/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.client.internal;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.dsl.base.BaseOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.HasMetadataOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.servicecatalog.api.client.internal.ClusterServiceBrokerResource;
import io.dekorate.deps.servicecatalog.api.client.internal.ClusterServiceClassOperationsImpl;
import io.dekorate.deps.servicecatalog.api.client.internal.ClusterServiceClassResource;
import io.dekorate.deps.servicecatalog.api.client.internal.ClusterServicePlanOperationsImpl;
import io.dekorate.deps.servicecatalog.api.model.ClusterServiceBroker;
import io.dekorate.deps.servicecatalog.api.model.ClusterServiceBrokerList;
import io.dekorate.deps.servicecatalog.api.model.ClusterServiceClass;
import io.dekorate.deps.servicecatalog.api.model.ClusterServiceClassList;
import io.dekorate.deps.servicecatalog.api.model.ClusterServicePlanList;
import io.dekorate.deps.servicecatalog.api.model.DoneableClusterServiceBroker;
import java.util.HashMap;
import java.util.List;

public class ClusterServiceBrokerOperationsImpl
extends HasMetadataOperation<ClusterServiceBroker, ClusterServiceBrokerList, DoneableClusterServiceBroker, ClusterServiceBrokerResource>
implements ClusterServiceBrokerResource {
    public ClusterServiceBrokerOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ClusterServiceBrokerOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("servicecatalog.k8s.io").withApiGroupVersion("v1beta1").withPlural("clusterservicebrokers"));
        this.type = ClusterServiceBroker.class;
        this.listType = ClusterServiceBrokerList.class;
        this.doneableType = DoneableClusterServiceBroker.class;
    }

    @Override
    public BaseOperation<ClusterServiceBroker, ClusterServiceBrokerList, DoneableClusterServiceBroker, ClusterServiceBrokerResource> newInstance(OperationContext context) {
        return new ClusterServiceBrokerOperationsImpl(context);
    }

    @Override
    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public ClusterServicePlanList listPlans() {
        ClusterServiceBroker item = (ClusterServiceBroker)this.get();
        return (ClusterServicePlanList)new ClusterServicePlanOperationsImpl(this.context).withField("spec.clusterServiceBrokerName", item.getMetadata().getName()).list();
    }

    @Override
    public ClusterServiceClassList listClasses() {
        ClusterServiceBroker item = (ClusterServiceBroker)this.get();
        return (ClusterServiceClassList)new ClusterServiceClassOperationsImpl(this.context).withField("spec.clusterServiceBrokerName", item.getMetadata().getName()).list();
    }

    @Override
    public ClusterServiceClassResource useServiceClass(String externalName) {
        ClusterServiceBroker item = (ClusterServiceBroker)this.get();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("spec.clusterServiceBrokerName", item.getMetadata().getName());
        fields.put("spec.externalName", externalName);
        List<ClusterServiceClass> list = ((ClusterServiceClassList)new ClusterServiceClassOperationsImpl(this.context.withFields(fields)).list()).getItems();
        if (list.size() != 1) {
            throw new IllegalArgumentException("No unique ClusterServiceClass with external name:" + externalName + "found for ClusterServiceBroker: " + item.getMetadata().getName());
        }
        ClusterServiceClass c = list.get(0);
        return new ClusterServiceClassOperationsImpl(this.context);
    }
}

