/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.client.internal;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.dsl.base.BaseOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.HasMetadataOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.servicecatalog.api.client.internal.ClusterServiceClassResource;
import io.dekorate.deps.servicecatalog.api.client.internal.ClusterServicePlanOperationsImpl;
import io.dekorate.deps.servicecatalog.api.client.internal.ClusterServicePlanResource;
import io.dekorate.deps.servicecatalog.api.client.internal.ServiceInstanceOperationsImpl;
import io.dekorate.deps.servicecatalog.api.model.ClusterServiceClass;
import io.dekorate.deps.servicecatalog.api.model.ClusterServiceClassList;
import io.dekorate.deps.servicecatalog.api.model.ClusterServicePlan;
import io.dekorate.deps.servicecatalog.api.model.ClusterServicePlanList;
import io.dekorate.deps.servicecatalog.api.model.DoneableClusterServiceClass;
import io.dekorate.deps.servicecatalog.api.model.DoneableServiceInstance;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstance;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceFluent;
import java.util.HashMap;
import java.util.List;

public class ClusterServiceClassOperationsImpl
extends HasMetadataOperation<ClusterServiceClass, ClusterServiceClassList, DoneableClusterServiceClass, ClusterServiceClassResource>
implements ClusterServiceClassResource {
    public ClusterServiceClassOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ClusterServiceClassOperationsImpl(OperationContext ctx) {
        super(ctx.withApiGroupName("servicecatalog.k8s.io").withApiGroupVersion("v1beta1").withPlural("clusterserviceclasses"));
        this.type = ClusterServiceClass.class;
        this.listType = ClusterServiceClassList.class;
        this.doneableType = DoneableClusterServiceClass.class;
    }

    @Override
    public BaseOperation<ClusterServiceClass, ClusterServiceClassList, DoneableClusterServiceClass, ClusterServiceClassResource> newInstance(OperationContext context) {
        return new ClusterServiceClassOperationsImpl(context);
    }

    @Override
    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public ClusterServicePlanList listPlans() {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        return (ClusterServicePlanList)new ClusterServicePlanOperationsImpl(this.context).withField("spec.clusterServiceClassRef.name", item != null ? item.getMetadata().getName() : null).list();
    }

    @Override
    public ClusterServicePlanResource usePlan(String externalName) {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("spec.clusterServiceClassRef.name", item.getMetadata().getName());
        fields.put("spec.externalName", externalName);
        List<ClusterServicePlan> list = ((ClusterServicePlanList)new ClusterServicePlanOperationsImpl(this.context.withFields(fields)).list()).getItems();
        if (list.size() != 1) {
            throw new IllegalArgumentException("No unique ClusterServicePlan with external name: " + externalName + " found for ClusterServiceBroker: " + item.getSpec().getClusterServiceBrokerName() + " and ClusterServiceClass: " + item.getSpec().getExternalName() + ".");
        }
        ClusterServicePlan p = list.get(0);
        return new ClusterServicePlanOperationsImpl(this.context);
    }

    @Override
    public ServiceInstance instantiate(String instanceName, String plan) {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        return ((DoneableServiceInstance)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((DoneableServiceInstance)((ServiceInstanceFluent.MetadataNested)((DoneableServiceInstance)new ServiceInstanceOperationsImpl(this.context).createNew()).withNewMetadata().withName(instanceName)).endMetadata()).withNewSpec().withClusterServiceClassExternalName(item.getMetadata().getName())).withClusterServicePlanExternalName(plan)).endSpec()).done();
    }
}

