/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.servicecatalog.api.model.ObjectReference;
import io.dekorate.deps.servicecatalog.api.model.ObjectReferenceFluent;
import io.dekorate.deps.servicecatalog.api.model.ObjectReferenceFluentImpl;

public class ObjectReferenceBuilder
extends ObjectReferenceFluentImpl<ObjectReferenceBuilder>
implements VisitableBuilder<ObjectReference, ObjectReferenceBuilder> {
    ObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ObjectReferenceBuilder() {
        this(true);
    }

    public ObjectReferenceBuilder(Boolean validationEnabled) {
        this(new ObjectReference(), validationEnabled);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ObjectReference(), validationEnabled);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, ObjectReference instance) {
        this(fluent, instance, true);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, ObjectReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public ObjectReferenceBuilder(ObjectReference instance) {
        this(instance, (Boolean)true);
    }

    public ObjectReferenceBuilder(ObjectReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public ObjectReferenceBuilder(Validator validator) {
        this(new ObjectReference(), (Boolean)true);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, ObjectReference instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ObjectReferenceBuilder(ObjectReference instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ObjectReference build() {
        ObjectReference buildable = new ObjectReference(this.fluent.getName(), this.fluent.getNamespace());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectReferenceBuilder that = (ObjectReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

