/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.servicecatalog.api.model.SecretKeyReference;
import io.dekorate.deps.servicecatalog.api.model.SecretKeyReferenceFluent;
import io.dekorate.deps.servicecatalog.api.model.SecretKeyReferenceFluentImpl;

public class SecretKeyReferenceBuilder
extends SecretKeyReferenceFluentImpl<SecretKeyReferenceBuilder>
implements VisitableBuilder<SecretKeyReference, SecretKeyReferenceBuilder> {
    SecretKeyReferenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SecretKeyReferenceBuilder() {
        this(true);
    }

    public SecretKeyReferenceBuilder(Boolean validationEnabled) {
        this(new SecretKeyReference(), validationEnabled);
    }

    public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretKeyReference(), validationEnabled);
    }

    public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent, SecretKeyReference instance) {
        this(fluent, instance, true);
    }

    public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent, SecretKeyReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKey(instance.getKey());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public SecretKeyReferenceBuilder(SecretKeyReference instance) {
        this(instance, (Boolean)true);
    }

    public SecretKeyReferenceBuilder(SecretKeyReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKey(instance.getKey());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public SecretKeyReferenceBuilder(Validator validator) {
        this(new SecretKeyReference(), (Boolean)true);
    }

    public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent, SecretKeyReference instance, Validator validator) {
        this.fluent = fluent;
        fluent.withKey(instance.getKey());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SecretKeyReferenceBuilder(SecretKeyReference instance, Validator validator) {
        this.fluent = this;
        this.withKey(instance.getKey());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public SecretKeyReference build() {
        SecretKeyReference buildable = new SecretKeyReference(this.fluent.getKey(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretKeyReferenceBuilder that = (SecretKeyReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

