/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.servicecatalog.api.model.ServiceBinding;
import io.dekorate.deps.servicecatalog.api.model.ServiceBindingFluent;
import io.dekorate.deps.servicecatalog.api.model.ServiceBindingFluentImpl;

public class ServiceBindingBuilder
extends ServiceBindingFluentImpl<ServiceBindingBuilder>
implements VisitableBuilder<ServiceBinding, ServiceBindingBuilder> {
    ServiceBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceBindingBuilder() {
        this(true);
    }

    public ServiceBindingBuilder(Boolean validationEnabled) {
        this(new ServiceBinding(), validationEnabled);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceBinding(), validationEnabled);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent, ServiceBinding instance) {
        this(fluent, instance, true);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent, ServiceBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBindingBuilder(ServiceBinding instance) {
        this(instance, (Boolean)true);
    }

    public ServiceBindingBuilder(ServiceBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBindingBuilder(Validator validator) {
        this(new ServiceBinding(), (Boolean)true);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent, ServiceBinding instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceBindingBuilder(ServiceBinding instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServiceBinding build() {
        ServiceBinding buildable = new ServiceBinding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingBuilder that = (ServiceBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

