/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.servicecatalog.api.model.ServiceBroker;
import io.dekorate.deps.servicecatalog.api.model.ServiceBrokerFluent;
import io.dekorate.deps.servicecatalog.api.model.ServiceBrokerFluentImpl;

public class ServiceBrokerBuilder
extends ServiceBrokerFluentImpl<ServiceBrokerBuilder>
implements VisitableBuilder<ServiceBroker, ServiceBrokerBuilder> {
    ServiceBrokerFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceBrokerBuilder() {
        this(true);
    }

    public ServiceBrokerBuilder(Boolean validationEnabled) {
        this(new ServiceBroker(), validationEnabled);
    }

    public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceBroker(), validationEnabled);
    }

    public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent, ServiceBroker instance) {
        this(fluent, instance, true);
    }

    public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent, ServiceBroker instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBrokerBuilder(ServiceBroker instance) {
        this(instance, (Boolean)true);
    }

    public ServiceBrokerBuilder(ServiceBroker instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBrokerBuilder(Validator validator) {
        this(new ServiceBroker(), (Boolean)true);
    }

    public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent, ServiceBroker instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceBrokerBuilder(ServiceBroker instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServiceBroker build() {
        ServiceBroker buildable = new ServiceBroker(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBrokerBuilder that = (ServiceBrokerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

